/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.watcher;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usefultoys.slf4j.Session;
import org.usefultoys.slf4j.watcher.Markers;
import org.usefultoys.slf4j.watcher.WatcherConfig;
import org.usefultoys.slf4j.watcher.WatcherData;

public class Watcher
extends WatcherData
implements Runnable {
    private static final long serialVersionUID = 1L;
    private final Logger messageLogger;
    private final Logger dataLogger;

    public Watcher(Logger logger) {
        super(Session.uuid);
        this.messageLogger = LoggerFactory.getLogger((String)(WatcherConfig.messagePrefix + logger.getName() + WatcherConfig.messageSuffix));
        this.dataLogger = LoggerFactory.getLogger((String)(WatcherConfig.dataPrefix + logger.getName() + WatcherConfig.dataSuffix));
    }

    @Override
    public void run() {
        this.logCurrentStatus();
    }

    public void logCurrentStatus() {
        this.nextPosition();
        if (this.messageLogger.isInfoEnabled()) {
            this.collectRuntimeStatus();
            this.collectPlatformStatus();
            this.collectManagedBeanStatus();
            this.messageLogger.info(Markers.MSG_WATCHER, this.readableMessage());
        }
        if (this.messageLogger.isTraceEnabled()) {
            this.dataLogger.trace(Markers.DATA_WATCHER, this.encodeAttributosAsString());
        }
    }
}

