/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.watcher;

import org.usefultoys.slf4j.SessionConfig;
import org.usefultoys.slf4j.internal.SystemData;
import org.usefultoys.slf4j.utils.UnitFormatter;

public class WatcherData
extends SystemData {
    private static final long serialVersionUID = 1L;
    public static final char DETAILED_MESSAGE_PREFIX = 'W';

    public WatcherData() {
    }

    protected WatcherData(String string) {
        super(string);
    }

    @Override
    public StringBuilder readableString(StringBuilder stringBuilder) {
        boolean bl = false;
        if (this.runtime_usedMemory > 0L || this.runtime_maxMemory > 0L || this.runtime_totalMemory > 0L) {
            stringBuilder.append("Memory: ");
            stringBuilder.append(UnitFormatter.bytes(this.runtime_usedMemory));
            stringBuilder.append(' ');
            stringBuilder.append(UnitFormatter.bytes(this.runtime_totalMemory));
            stringBuilder.append(' ');
            stringBuilder.append(UnitFormatter.bytes(this.runtime_maxMemory));
            bl = true;
        }
        if (this.systemLoad > 0.0) {
            if (bl) {
                stringBuilder.append("; ");
            }
            stringBuilder.append("System load: ");
            stringBuilder.append(Math.round(this.systemLoad * 100.0));
            stringBuilder.append("%");
            bl = true;
        }
        if (SessionConfig.uuidSize != 0 && this.sessionUuid != null) {
            if (bl) {
                stringBuilder.append("; ");
            }
            stringBuilder.append("UUID: ");
            stringBuilder.append(this.sessionUuid.substring(32 - SessionConfig.uuidSize));
        }
        return stringBuilder;
    }

    public final boolean decodeAttributesFromString(String string) {
        return this.read(string, 'W');
    }

    public final String encodeAttributosAsString() {
        return this.write(new StringBuilder(200), 'W').toString();
    }

    public final String readableMessage() {
        return this.readableString(new StringBuilder(200)).toString();
    }
}

