/*
 * Decompiled with CFR 0.152.
 */
package org.usefultoys.slf4j.watcher;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.usefultoys.slf4j.LoggerFactory;
import org.usefultoys.slf4j.watcher.Watcher;
import org.usefultoys.slf4j.watcher.WatcherConfig;

public final class WatcherSingleton {
    public static final Watcher DEFAULT_WATCHER = new Watcher(LoggerFactory.getLogger(WatcherConfig.name));
    private static ScheduledExecutorService defaultWatcherExecutor = null;
    private static ScheduledFuture<?> scheduledDefaultWatcher = null;
    private static Timer defaultWatcherTimer = null;
    private static TimerTask defaultWatcherTask = null;

    private WatcherSingleton() {
    }

    public static synchronized void startDefaultWatcherExecutor() {
        if (defaultWatcherExecutor == null) {
            defaultWatcherExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        if (scheduledDefaultWatcher == null) {
            scheduledDefaultWatcher = defaultWatcherExecutor.scheduleAtFixedRate(DEFAULT_WATCHER, WatcherConfig.delayMilliseconds, WatcherConfig.periodMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    public static synchronized void stopDefaultWatcherExecutor() {
        if (scheduledDefaultWatcher != null) {
            scheduledDefaultWatcher.cancel(true);
        }
        if (defaultWatcherExecutor != null) {
            defaultWatcherExecutor.shutdownNow();
            defaultWatcherExecutor = null;
        }
    }

    public static synchronized void startDefaultWatcherTimer() {
        if (defaultWatcherTimer == null) {
            defaultWatcherTimer = new Timer("Watcher");
        }
        if (defaultWatcherTask == null) {
            defaultWatcherTask = new TimerTask(){

                @Override
                public void run() {
                    DEFAULT_WATCHER.logCurrentStatus();
                }
            };
            defaultWatcherTimer.schedule(defaultWatcherTask, WatcherConfig.delayMilliseconds, WatcherConfig.periodMilliseconds);
        }
    }

    public static synchronized void stopDefaultWatcherTimer() {
        if (defaultWatcherTimer != null) {
            defaultWatcherTimer.cancel();
        }
        if (defaultWatcherTask != null) {
            defaultWatcherTask = null;
        }
    }
}

