/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.flowingcode.vaadin.addons.gridhelpers.HeightMode;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.grid.Grid;
import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;

class HeightByRowsHelper
implements Serializable {
    private static final String THEME = "height-by-rows";
    private final GridHelper<?> helper;
    private double heightByRows;
    private HeightMode heightMode;

    void setHeightByRows(double rows) {
        if (rows <= 0.0) {
            throw new IllegalArgumentException("More than zero rows must be shown.");
        }
        if (Double.isInfinite(rows)) {
            throw new IllegalArgumentException("Grid doesn't support infinite heights");
        }
        if (Double.isNaN(rows)) {
            throw new IllegalArgumentException("NaN is not a valid row count");
        }
        this.heightByRows = rows;
        Grid<?> grid = this.helper.getGrid();
        if (this.heightMode == HeightMode.ROW && grid.isAttached()) {
            grid.getElement().executeJs("this.fcGridHelper.setHeightByRows($0)", new Serializable[]{Double.valueOf(rows)});
            grid.setThemeName(THEME, this.heightMode == HeightMode.ROW);
        }
    }

    void setHeightMode(HeightMode heightMode) {
        if (this.heightMode == null) {
            this.helper.getGrid().addAttachListener((ComponentEventListener & Serializable)ev -> {
                if (heightMode == HeightMode.ROW) {
                    this.setHeightByRows(this.heightByRows);
                }
            });
        }
        this.heightMode = heightMode;
        if (heightMode == HeightMode.ROW && this.heightByRows != 0.0) {
            this.setHeightByRows(this.heightByRows);
            this.helper.getGrid().addThemeName(THEME);
        } else {
            this.helper.getGrid().removeThemeName(THEME);
        }
    }

    HeightMode getHeightMode() {
        return Optional.ofNullable(this.heightMode).orElse(HeightMode.CSS);
    }

    @Generated
    public HeightByRowsHelper(GridHelper<?> helper) {
        this.helper = helper;
    }

    @Generated
    public double getHeightByRows() {
        return this.heightByRows;
    }
}

