/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;
import org.vaadin.spring.security.config.AbstractVaadinSecurityConfiguration;
import org.vaadin.spring.security.config.AuthenticationManagerConfigurer;
import org.vaadin.spring.security.managed.DefaultVaadinManagedSecurity;
import org.vaadin.spring.security.managed.SecurityContextVaadinRequestListener;
import org.vaadin.spring.security.managed.VaadinManagedSecurity;

@Configuration
public class VaadinManagedSecurityConfiguration
extends AbstractVaadinSecurityConfiguration {
    @Override
    VaadinManagedSecurity vaadinSecurity() {
        return new DefaultVaadinManagedSecurity();
    }

    @Bean
    SecurityContextVaadinRequestListener securityContextVaadinRequestListener() {
        return new SecurityContextVaadinRequestListener();
    }

    @Configuration
    @EnableGlobalMethodSecurity(securedEnabled=true, prePostEnabled=true, proxyTargetClass=true)
    static class GlobalMethodSecurity
    extends GlobalMethodSecurityConfiguration {
        @Autowired
        ApplicationContext applicationContext;

        GlobalMethodSecurity() {
        }

        @Bean(name={"accessDecisionManager"})
        protected AccessDecisionManager accessDecisionManager() {
            return super.accessDecisionManager();
        }

        @Bean(name={"authenticationManager"})
        protected AuthenticationManager authenticationManager() throws Exception {
            return super.authenticationManager();
        }

        protected void configure(AuthenticationManagerBuilder auth) throws Exception {
            try {
                ((AuthenticationManagerConfigurer)this.applicationContext.getBean(AuthenticationManagerConfigurer.class)).configure(auth);
            }
            catch (Exception ex) {
                throw new IllegalStateException("No AuthenticationManagerConfigurer found. Either define one, or override the GlobalMethodSecurity.configure(AuthenticationManagerBuilder) method.");
            }
        }
    }
}

