/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.managed;

import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WrappedSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.vaadin.spring.request.VaadinRequestEndListener;
import org.vaadin.spring.request.VaadinRequestStartListener;

public class SecurityContextVaadinRequestListener
implements VaadinRequestStartListener,
VaadinRequestEndListener {
    public static final String SECURITY_CONTEXT_SESSION_ATTRIBUTE = "org.vaadin.spring.security.internal.springSecurityContext";
    private static final Logger logger = LoggerFactory.getLogger(SecurityContextVaadinRequestListener.class);

    public SecurityContextVaadinRequestListener() {
        logger.info("Initializing {}, setting SecurityContextHolder strategy to {}", (Object)this.getClass().getSimpleName(), (Object)"MODE_INHERITABLETHREADLOCAL");
        SecurityContextHolder.setStrategyName((String)"MODE_INHERITABLETHREADLOCAL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestStart(VaadinRequest request, VaadinResponse response) {
        WrappedSession wrappedSession = request.getWrappedSession(false);
        VaadinSession session = null;
        if (wrappedSession != null) {
            session = VaadinSession.getForSession((VaadinService)request.getService(), (WrappedSession)wrappedSession);
        }
        SecurityContextHolder.clearContext();
        if (session != null) {
            SecurityContext securityContext;
            logger.trace("Loading security context from VaadinSession {}", (Object)session);
            session.lock();
            try {
                securityContext = (SecurityContext)session.getAttribute(SECURITY_CONTEXT_SESSION_ATTRIBUTE);
            }
            finally {
                session.unlock();
            }
            if (securityContext == null) {
                logger.trace("No security context found in VaadinSession {}", (Object)session);
            } else {
                logger.trace("Setting security context to {}", (Object)securityContext);
                SecurityContextHolder.setContext((SecurityContext)securityContext);
            }
        } else {
            logger.trace("No VaadinSession available for retrieving the security context");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestEnd(VaadinRequest request, VaadinResponse response, VaadinSession session) {
        block7: {
            try {
                if (session != null) {
                    SecurityContext securityContext = SecurityContextHolder.getContext();
                    logger.trace("Storing security context {} in VaadinSession {}", (Object)securityContext, (Object)session);
                    session.lock();
                    try {
                        session.setAttribute(SECURITY_CONTEXT_SESSION_ATTRIBUTE, (Object)securityContext);
                        break block7;
                    }
                    finally {
                        session.unlock();
                    }
                }
                logger.trace("No VaadinSession available for storing the security context");
            }
            finally {
                logger.trace("Clearing security context");
                SecurityContextHolder.clearContext();
            }
        }
    }
}

