/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.navigation;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.spring.access.ViewInstanceAccessControl;
import com.vaadin.ui.UI;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.ExpressionBasedAnnotationAttributeFactory;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PreInvocationAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.util.MethodInvocationUtils;
import org.springframework.util.ClassUtils;
import org.vaadin.spring.security.VaadinSecurity;
import org.vaadin.spring.security.VaadinSecurityAware;

public class PreAuthorizeViewInstanceAccessControl
implements ApplicationContextAware,
VaadinSecurityAware,
ViewInstanceAccessControl {
    private static final Logger logger = LoggerFactory.getLogger(PreAuthorizeViewInstanceAccessControl.class);
    private VaadinSecurity security;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setVaadinSecurity(VaadinSecurity vaadinSecurity) {
        this.security = vaadinSecurity;
    }

    public boolean isAccessGranted(UI ui, String beanName, View view) {
        PreAuthorize viewSecured = (PreAuthorize)this.applicationContext.findAnnotationOnBean(beanName, PreAuthorize.class);
        if (viewSecured == null) {
            logger.trace("No @PreAuthorize annotation found on view {}. Granting access.", (Object)beanName);
            return true;
        }
        if (this.security.hasAccessDecisionManager()) {
            Class targetClass = AopUtils.getTargetClass((Object)view);
            Method method = ClassUtils.getMethod((Class)targetClass, (String)"enter", (Class[])new Class[]{ViewChangeListener.ViewChangeEvent.class});
            MethodInvocation methodInvocation = MethodInvocationUtils.createFromClass((Class)targetClass, (String)method.getName());
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            AccessDecisionManager accessDecisionManager = this.security.getAccessDecisionManager();
            ExpressionBasedAnnotationAttributeFactory attributeFactory = new ExpressionBasedAnnotationAttributeFactory((MethodSecurityExpressionHandler)new DefaultMethodSecurityExpressionHandler());
            Set<PreInvocationAttribute> attributes = Collections.singleton(attributeFactory.createPreInvocationAttribute(null, null, viewSecured.value()));
            try {
                accessDecisionManager.decide(authentication, (Object)methodInvocation, attributes);
                logger.trace("Access to view {} was granted by access decision manager", (Object)beanName);
                return true;
            }
            catch (InsufficientAuthenticationException e) {
                logger.trace("Access to view {} was denied because of insufficient authentication credentials", (Object)beanName);
                return false;
            }
            catch (AccessDeniedException e) {
                logger.trace("Access to view {} was denied", (Object)beanName);
                return false;
            }
        }
        logger.warn("Found view {} annotated with @PreAuthorize but no access decision manager. Granting access.", (Object)beanName);
        return true;
    }
}

