/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.shared;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.vaadin.spring.http.HttpService;
import org.vaadin.spring.security.web.VaadinRedirectStrategy;

public abstract class AbstractVaadinAuthenticationTargetUrlRequestHandler {
    protected final VaadinRedirectStrategy redirectStrategy;
    protected final HttpService http;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String targetUrlParameter = null;
    private String defaultTargetUrl = "/";
    private boolean alwaysUseDefaultTargetUrl = false;
    private boolean useReferer = false;

    protected AbstractVaadinAuthenticationTargetUrlRequestHandler(HttpService http, VaadinRedirectStrategy redirectStrategy) {
        this.http = http;
        this.redirectStrategy = redirectStrategy;
    }

    protected void handle(Authentication authentication) throws IOException, ServletException {
        HttpServletRequest request = this.http.getCurrentRequest();
        HttpServletResponse response = this.http.getCurrentResponse();
        String targetUrl = this.determineTargetUrl(request, response);
        if (response.isCommitted()) {
            this.logger.debug("Response has already been committed. Unable to redirect to " + targetUrl);
            return;
        }
        this.logger.debug("Redirecting to " + targetUrl);
        this.redirectStrategy.sendRedirect(targetUrl);
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        if (this.isAlwaysUseDefaultTargetUrl()) {
            return this.defaultTargetUrl;
        }
        String targetUrl = null;
        if (this.targetUrlParameter != null && StringUtils.hasText((String)(targetUrl = request.getParameter(this.targetUrlParameter)))) {
            this.logger.debug("Found targetUrlParameter in request: " + targetUrl);
            return targetUrl;
        }
        if (this.useReferer && !StringUtils.hasLength((String)targetUrl)) {
            targetUrl = request.getHeader("Referer");
            this.logger.debug("Using Referer header: " + targetUrl);
        }
        if (!StringUtils.hasText((String)targetUrl)) {
            targetUrl = this.defaultTargetUrl;
            this.logger.debug("Using default Url: " + targetUrl);
        }
        return targetUrl;
    }

    protected final String getDefaultTargetUrl() {
        return this.defaultTargetUrl;
    }

    public void setDefaultTargetUrl(String defaultTargetUrl) {
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)defaultTargetUrl), (String)"defaultTarget must start with '/' or with 'http(s)'");
        this.defaultTargetUrl = defaultTargetUrl;
    }

    protected boolean isAlwaysUseDefaultTargetUrl() {
        return this.alwaysUseDefaultTargetUrl;
    }

    public void setAlwaysUseDefaultTargetUrl(boolean alwaysUseDefaultTargetUrl) {
        this.alwaysUseDefaultTargetUrl = alwaysUseDefaultTargetUrl;
    }

    protected String getTargetUrlParameter() {
        return this.targetUrlParameter;
    }

    public void setTargetUrlParameter(String targetUrlParameter) {
        if (targetUrlParameter != null) {
            Assert.hasText((String)targetUrlParameter, (String)"targetUrlParameter cannot be empty");
        }
        this.targetUrlParameter = targetUrlParameter;
    }

    public void setUseReferer(boolean useReferer) {
        this.useReferer = useReferer;
    }
}

