/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.shared;

import com.vaadin.server.VaadinSession;
import com.vaadin.server.WrappedSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.util.Assert;
import org.vaadin.spring.http.HttpService;
import org.vaadin.spring.security.AbstractVaadinSecurity;
import org.vaadin.spring.security.shared.VaadinAuthenticationSuccessHandler;
import org.vaadin.spring.security.shared.VaadinLogoutHandler;
import org.vaadin.spring.security.shared.VaadinSharedSecurity;

public class DefaultVaadinSharedSecurity
extends AbstractVaadinSecurity
implements VaadinSharedSecurity {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultVaadinSharedSecurity.class);
    @Autowired
    HttpService httpService;
    @Autowired(required=false)
    SessionAuthenticationStrategy sessionAuthenticationStrategy;
    @Autowired(required=false)
    VaadinAuthenticationSuccessHandler vaadinAuthenticationSuccessHandler;
    @Autowired(required=false)
    VaadinLogoutHandler vaadinLogoutHandler;
    private String springSecurityContextKey = "SPRING_SECURITY_CONTEXT";
    private boolean saveContextInSessionAfterLogin = false;

    @Override
    public Authentication login(Authentication authentication, boolean rememberMe) throws Exception {
        RememberMeRequestWrapper request = new RememberMeRequestWrapper(this.getCurrentRequest(), rememberMe, this.getRememberMeParameter());
        HttpServletResponse response = this.getCurrentResponse();
        try {
            LOGGER.debug("Attempting authentication of {}, rememberMe = {}", (Object)authentication, (Object)rememberMe);
            Authentication fullyAuthenticated = this.getAuthenticationManager().authenticate(authentication);
            LOGGER.debug("Invoking session authentication strategy");
            this.sessionAuthenticationStrategy.onAuthentication(fullyAuthenticated, (HttpServletRequest)request, response);
            this.successfulAuthentication(fullyAuthenticated, (HttpServletRequest)request, response);
            Authentication authentication2 = fullyAuthenticated;
            return authentication2;
        }
        catch (Exception e) {
            this.unsuccessfulAuthentication((HttpServletRequest)request, response);
            throw e;
        }
        finally {
            if (this.saveContextInSessionAfterLogin) {
                LOGGER.debug("Saving security context in the session");
                WrappedSession session = this.getSession();
                if (session != null) {
                    session.setAttribute(this.springSecurityContextKey, (Object)SecurityContextHolder.getContext());
                } else {
                    LOGGER.warn("Tried to save security context in the session, but no session was bound to the current thread");
                }
            }
        }
    }

    protected String getRememberMeParameter() {
        if (this.getRememberMeServices() instanceof AbstractRememberMeServices) {
            return ((AbstractRememberMeServices)this.getRememberMeServices()).getParameter();
        }
        return "remember-me";
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("Authentication failed");
        SecurityContextHolder.clearContext();
        this.getRememberMeServices().loginFail(request, response);
    }

    protected void successfulAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOGGER.debug("Authentication succeeded");
        SecurityContextHolder.getContext().setAuthentication(authentication);
        this.getRememberMeServices().loginSuccess(request, response, authentication);
        this.vaadinAuthenticationSuccessHandler.onAuthenticationSuccess(authentication);
    }

    protected HttpServletRequest getCurrentRequest() {
        HttpServletRequest request = this.httpService.getCurrentRequest();
        if (request == null) {
            throw new IllegalStateException("No HttpServletRequest bound to current thread");
        }
        return request;
    }

    protected HttpServletResponse getCurrentResponse() {
        HttpServletResponse response = this.httpService.getCurrentResponse();
        if (response == null) {
            throw new IllegalStateException("No HttpServletResponse bound to current thread");
        }
        return response;
    }

    @Override
    public Authentication login(String username, String password, boolean rememberMe) throws Exception {
        return this.login((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password), rememberMe);
    }

    @Override
    public Authentication login(Authentication authentication) throws Exception {
        return this.login(authentication, false);
    }

    @Override
    public void logout() {
        this.vaadinLogoutHandler.onLogout();
    }

    @Override
    public Authentication getAuthentication() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            LOGGER.debug("No authentication object bound to thread, trying to access the session directly");
            WrappedSession session = this.getSession();
            if (session != null) {
                SecurityContext context = (SecurityContext)session.getAttribute(this.springSecurityContextKey);
                authentication = context.getAuthentication();
            } else {
                LOGGER.debug("No session bound to current thread, cannot retrieve the authentication object");
            }
        }
        return authentication;
    }

    private WrappedSession getSession() {
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        if (vaadinSession != null) {
            return vaadinSession.getSession();
        }
        return null;
    }

    public void setSpringSecurityContextKey(String springSecurityContextKey) {
        Assert.hasText((String)springSecurityContextKey, (String)"springSecurityContextKey cannot be empty");
        this.springSecurityContextKey = springSecurityContextKey;
    }

    public void setSaveContextInSessionAfterLogin(boolean saveContextInSessionAfterLogin) {
        this.saveContextInSessionAfterLogin = saveContextInSessionAfterLogin;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.sessionAuthenticationStrategy == null) {
            LOGGER.info("No session authentication strategy found in application context, using null strategy");
            this.sessionAuthenticationStrategy = new NullAuthenticatedSessionStrategy();
        } else {
            LOGGER.info("Using session authentication strategy {}", (Object)this.sessionAuthenticationStrategy);
        }
        if (this.vaadinAuthenticationSuccessHandler == null) {
            LOGGER.info("No authentication success handler found in the application context, using null handler");
            this.vaadinAuthenticationSuccessHandler = new VaadinAuthenticationSuccessHandler.NullHandler();
        } else {
            LOGGER.info("Using authentication success handler {}", (Object)this.vaadinAuthenticationSuccessHandler);
        }
        if (this.vaadinLogoutHandler == null) {
            LOGGER.info("No logout handler found in the application context, using null handler");
            this.vaadinLogoutHandler = new VaadinLogoutHandler.NullHandler();
        } else {
            LOGGER.info("Using logout handler {}", (Object)this.vaadinLogoutHandler);
        }
    }

    public void setVaadinAuthenticationSuccessHandler(VaadinAuthenticationSuccessHandler vaadinAuthenticationSuccessHandler) {
        this.vaadinAuthenticationSuccessHandler = vaadinAuthenticationSuccessHandler;
    }

    protected VaadinAuthenticationSuccessHandler getVaadinAuthenticationSuccessHandler() {
        return this.vaadinAuthenticationSuccessHandler;
    }

    public void setSessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        this.sessionAuthenticationStrategy = sessionAuthenticationStrategy;
    }

    protected SessionAuthenticationStrategy getSessionAuthenticationStrategy() {
        return this.sessionAuthenticationStrategy;
    }

    public void setVaadinLogoutHandler(VaadinLogoutHandler vaadinLogoutHandler) {
        this.vaadinLogoutHandler = vaadinLogoutHandler;
    }

    protected VaadinLogoutHandler getVaadinLogoutHandler() {
        return this.vaadinLogoutHandler;
    }

    protected final class RememberMeRequestWrapper
    extends HttpServletRequestWrapper {
        private final String parameter;
        private final String rememberMe;

        public RememberMeRequestWrapper(HttpServletRequest request, boolean rememberMe, String parameter) {
            super(request);
            this.rememberMe = Boolean.toString(rememberMe);
            this.parameter = parameter;
        }

        public String getParameter(String name) {
            if (this.parameter.equals(name)) {
                return this.rememberMe;
            }
            return super.getParameter(name);
        }
    }
}

