/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.shared;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PushSecurityInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushSecurityInterceptor.class);
    private SecurityContextRepository securityContextRepository;

    private synchronized SecurityContextRepository getSecurityContextRepository(ServletContext servletContext) {
        if (this.securityContextRepository == null) {
            WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            try {
                this.securityContextRepository = (SecurityContextRepository)applicationContext.getBean(SecurityContextRepository.class);
            }
            catch (BeansException ex) {
                LOGGER.info("Found no SecurityContextRepository in the application context, using HttpSessionSecurityContextRepository");
                this.securityContextRepository = new HttpSessionSecurityContextRepository();
            }
        }
        return this.securityContextRepository;
    }

    public Action inspect(AtmosphereResource r) {
        SecurityContextRepository securityContextRepository = this.getSecurityContextRepository(r.getAtmosphereConfig().getServletContext());
        if (securityContextRepository.containsContext((HttpServletRequest)r.getRequest())) {
            LOGGER.trace("Loading the security context from the session");
            HttpRequestResponseHolder requestResponse = new HttpRequestResponseHolder((HttpServletRequest)r.getRequest(), (HttpServletResponse)r.getResponse());
            SecurityContext securityContext = securityContextRepository.loadContext(requestResponse);
            SecurityContextHolder.setContext((SecurityContext)securityContext);
        }
        return Action.CONTINUE;
    }

    public void postInspect(AtmosphereResource r) {
        LOGGER.trace("Clearing security context");
        SecurityContextHolder.clearContext();
    }
}

