/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.shared;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;
import org.vaadin.spring.http.HttpService;
import org.vaadin.spring.security.shared.VaadinUrlAuthenticationSuccessHandler;
import org.vaadin.spring.security.web.VaadinRedirectStrategy;

public class SavedRequestAwareVaadinAuthenticationSuccessHandler
extends VaadinUrlAuthenticationSuccessHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RequestCache requestCache = new HttpSessionRequestCache();

    public SavedRequestAwareVaadinAuthenticationSuccessHandler(HttpService http, VaadinRedirectStrategy redirectStrategy, String defaultTargetUrl) {
        super(http, redirectStrategy, defaultTargetUrl);
    }

    @Override
    public void onAuthenticationSuccess(Authentication authentication) throws Exception {
        HttpServletResponse response;
        HttpServletRequest request = this.http.getCurrentRequest();
        SavedRequest savedRequest = this.requestCache.getRequest(request, response = this.http.getCurrentResponse());
        if (savedRequest == null) {
            super.onAuthenticationSuccess(authentication);
            return;
        }
        String targetUrlParameter = this.getTargetUrlParameter();
        if (this.isAlwaysUseDefaultTargetUrl() || targetUrlParameter != null && StringUtils.hasText((String)request.getParameter(targetUrlParameter))) {
            this.requestCache.removeRequest(request, response);
            super.onAuthenticationSuccess(authentication);
            return;
        }
        this.clearAuthenticationAttributes();
        String targetUrl = savedRequest.getRedirectUrl();
        this.logger.debug("Redirecting to saved request redirect url: " + targetUrl);
        this.redirectStrategy.sendRedirect(targetUrl);
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }
}

