/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.descriptors;

import org.vafer.jdeb.changes.ChangeSet;
import org.vafer.jdeb.descriptors.AbstractDescriptor;

public final class ChangesDescriptor
extends AbstractDescriptor {
    private static final String[] keys = new String[]{"Format", "Date", "Source", "Binary", "Architecture", "Version", "Distribution", "Urgency", "Maintainer", "Changed-By", "Description", "Changes", "Closes", "Checksums-Sha1", "Checksums-Sha256", "Files"};
    public static final String[] mandatoryKeys = new String[]{"Format", "Date", "Source", "Binary", "Architecture", "Version", "Distribution", "Urgency", "Maintainer", "Description", "Changes", "Checksums-Sha1", "Checksums-Sha256", "Files"};
    private final ChangeSet[] changeSets;

    public ChangesDescriptor(AbstractDescriptor pDescriptor, ChangeSet[] pChangeSets) {
        super(pDescriptor);
        this.changeSets = pChangeSets;
        StringBuilder sb = new StringBuilder();
        if (this.changeSets.length > 0) {
            ChangeSet lastestChangeSet = this.changeSets[0];
            this.set("Urgency", lastestChangeSet.getUrgency());
            this.set("Changed-By", lastestChangeSet.getChangedBy());
            for (int i = 0; i < 1; ++i) {
                ChangeSet changeSet = this.changeSets[i];
                sb.append(changeSet.toString());
            }
        }
        this.set("Changes", sb.toString());
    }

    @Override
    public String[] getMandatoryKeys() {
        return mandatoryKeys;
    }

    public String toString() {
        return this.toString(keys);
    }
}

