/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.mapping;

import org.apache.tools.tar.TarEntry;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.utils.Utils;

public final class PermMapper
implements Mapper {
    private final int strip;
    private final String prefix;
    private int uid = -1;
    private int gid = -1;
    private String user;
    private String group;
    private int fileMode = -1;
    private int dirMode = -1;

    public static int toMode(String modeString) {
        int mode = -1;
        if (modeString != null && modeString.length() > 0) {
            mode = Integer.parseInt(modeString, 8);
        }
        return mode;
    }

    public PermMapper(int uid, int gid, String user, String group, int fileMode, int dirMode, int strip, String prefix) {
        this.strip = strip;
        this.prefix = prefix == null ? "" : prefix;
        this.uid = uid;
        this.gid = gid;
        this.user = user;
        this.group = group;
        this.fileMode = fileMode;
        this.dirMode = dirMode;
    }

    public PermMapper(int uid, int gid, String user, String group, String fileMode, String dirMode, int strip, String prefix) {
        this(uid, gid, user, group, PermMapper.toMode(fileMode), PermMapper.toMode(dirMode), strip, prefix);
    }

    @Override
    public TarEntry map(TarEntry entry) {
        String name = entry.getName();
        TarEntry newEntry = new TarEntry(this.prefix + '/' + Utils.stripPath(this.strip, name));
        if (this.uid > -1) {
            newEntry.setUserId(this.uid);
        } else {
            newEntry.setUserId(entry.getUserId());
        }
        if (this.gid > -1) {
            newEntry.setGroupId(this.gid);
        } else {
            newEntry.setGroupId(entry.getGroupId());
        }
        if (this.user != null) {
            newEntry.setUserName(this.user);
        } else {
            newEntry.setUserName(entry.getUserName());
        }
        if (this.group != null) {
            newEntry.setGroupName(this.group);
        } else {
            newEntry.setGroupName(entry.getGroupName());
        }
        if (newEntry.isDirectory()) {
            if (this.dirMode > -1) {
                newEntry.setMode(this.dirMode);
            } else {
                newEntry.setMode(entry.getMode());
            }
        } else if (this.fileMode > -1) {
            newEntry.setMode(this.fileMode);
        } else {
            newEntry.setMode(entry.getMode());
        }
        newEntry.setSize(entry.getSize());
        return newEntry;
    }
}

