/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.PackagingException;
import org.vafer.jdeb.Processor;
import org.vafer.jdeb.changes.TextfileChangesProvider;
import org.vafer.jdeb.descriptors.PackageDescriptor;
import org.vafer.jdeb.maven.Data;
import org.vafer.jdeb.utils.VariableResolver;

public class DebMaker {
    private Console console;
    private File deb;
    private File control;
    private File keyring;
    private String key;
    private String passphrase;
    private File changesIn;
    private File changesOut;
    private File changesSave;
    private String compression = "gzip";
    private final VariableResolver variableResolver;
    private final Collection dataProducers;

    public DebMaker(Console console, VariableResolver variableResolver) {
        this(console, null, null, null, variableResolver);
    }

    public DebMaker(Console console, File deb, File controlDir, VariableResolver variableResolver) {
        this(console, deb, controlDir, null, variableResolver);
    }

    public DebMaker(Console console, File deb, File controlDir, Collection dataProducers, VariableResolver variableResolver) {
        this.console = console;
        this.deb = deb;
        this.control = controlDir;
        this.variableResolver = variableResolver;
        this.dataProducers = dataProducers != null ? dataProducers : new ArrayList();
    }

    public void setDeb(File deb) {
        this.deb = deb;
    }

    public void setControl(File control) {
        this.control = control;
    }

    public void setChangesIn(File changes) {
        this.changesIn = changes;
    }

    public void setChangesOut(File changes) {
        this.changesOut = changes;
    }

    public void setChangesSave(File changes) {
        this.changesSave = changes;
    }

    public void setKeyring(File keyring) {
        this.keyring = keyring;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public void addData(File file) {
        Data data = new Data();
        data.setSrc(file);
        this.dataProducers.add(data);
    }

    public void addData(Data data) {
        this.dataProducers.add(data);
    }

    private boolean isPossibleOutput(File file) {
        if (file.exists()) {
            return file.isFile() && file.canWrite();
        }
        return true;
    }

    public void makeDeb() throws PackagingException {
        TextfileChangesProvider changesProvider;
        PackageDescriptor packageDescriptor;
        if (this.control == null || !this.control.isDirectory()) {
            throw new PackagingException("\"" + this.control + "\" is not a valid 'control' directory)");
        }
        if (this.changesIn != null) {
            if (!this.changesIn.isFile() || !this.changesIn.canRead()) {
                throw new PackagingException("The 'changesIn' setting needs to point to a readable file. " + this.changesIn + " was not found/readable.");
            }
            if (this.changesOut == null) {
                throw new PackagingException("A 'changesIn' without a 'changesOut' does not make much sense.");
            }
            if (!this.isPossibleOutput(this.changesOut)) {
                throw new PackagingException("Cannot write the output for 'changesOut' to " + this.changesOut);
            }
            if (this.changesSave != null && !this.isPossibleOutput(this.changesSave)) {
                throw new PackagingException("Cannot write the output for 'changesSave' to " + this.changesSave);
            }
        } else if (this.changesOut != null || this.changesSave != null) {
            throw new PackagingException("The 'changesOut' or 'changesSave' settings may only be used when there is a 'changesIn' specified.");
        }
        if (!("gzip".equals(this.compression) || "bzip2".equals(this.compression) || "none".equals(this.compression))) {
            throw new PackagingException("The compression method '" + this.compression + "' is not supported");
        }
        if (this.deb == null) {
            throw new PackagingException("You need to specify where the deb file is supposed to be created.");
        }
        File[] controlFiles = this.control.listFiles();
        DataProducer[] data = new DataProducer[this.dataProducers.size()];
        this.dataProducers.toArray(data);
        Processor processor = new Processor(this.console, this.variableResolver);
        try {
            this.console.info("Creating debian package: " + this.deb);
            packageDescriptor = processor.createDeb(controlFiles, data, this.deb, this.compression);
        }
        catch (Exception e) {
            throw new PackagingException("Failed to create debian package " + this.deb, e);
        }
        try {
            if (this.changesOut == null) {
                return;
            }
            this.console.info("Creating changes file: " + this.changesOut);
            changesProvider = new TextfileChangesProvider(new FileInputStream(this.changesIn), packageDescriptor);
            processor.createChanges(packageDescriptor, changesProvider, this.keyring != null ? new FileInputStream(this.keyring) : null, this.key, this.passphrase, new FileOutputStream(this.changesOut));
        }
        catch (Exception e) {
            throw new PackagingException("Failed to create debian changes file " + this.changesOut, e);
        }
        try {
            if (this.changesSave == null) {
                return;
            }
            this.console.info("Saving changes to file: " + this.changesSave);
            changesProvider.save(new FileOutputStream(this.changesSave));
        }
        catch (Exception e) {
            throw new PackagingException("Failed to save debian changes file " + this.changesSave, e);
        }
    }
}

