/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.maven;

import java.io.File;
import java.io.FileInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.PackagingException;
import org.vafer.jdeb.descriptors.AbstractDescriptor;
import org.vafer.jdeb.maven.AbstractPluginMojo;
import org.vafer.jdeb.maven.Data;
import org.vafer.jdeb.maven.DebMaker;
import org.vafer.jdeb.maven.MojoConsole;
import org.vafer.jdeb.utils.MapVariableResolver;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

public class DebMojo
extends AbstractPluginMojo {
    private MavenProjectHelper projectHelper;
    private String deb;
    private String controlDir;
    private String changesIn;
    private String changesOut;
    private String changesSave;
    private String compression;
    private String attach;
    private String installDir;
    private String type;
    private File baseDir;
    private boolean submodules;
    private MavenSession session;
    private String classifier;
    private Data[] dataSet;
    private boolean timestamped;
    private boolean verbose;
    private String openReplaceToken = "[[";
    private String closeReplaceToken = "]]";
    private Collection dataProducers = new ArrayList();

    public void setOpenReplaceToken(String openReplaceToken) {
        this.openReplaceToken = openReplaceToken;
        AbstractDescriptor.setOpenToken(openReplaceToken);
    }

    public void setCloseReplaceToken(String closeReplaceToken) {
        this.closeReplaceToken = closeReplaceToken;
        AbstractDescriptor.setCloseToken(closeReplaceToken);
    }

    protected void setData(Data[] pData) {
        this.dataSet = pData;
        this.dataProducers.clear();
        if (pData != null) {
            for (int i = 0; i < pData.length; ++i) {
                this.dataProducers.add(pData[i]);
            }
        }
    }

    protected VariableResolver initializeVariableResolver(Map variables) {
        variables.putAll(this.getProject().getProperties());
        variables.put("name", this.getProject().getName());
        variables.put("artifactId", this.getProject().getArtifactId());
        variables.put("groupId", this.getProject().getGroupId());
        variables.put("version", this.getProjectVersion());
        variables.put("description", this.getProject().getDescription());
        variables.put("extension", "deb");
        variables.put("baseDir", this.getProject().getBasedir().getAbsolutePath());
        variables.put("buildDir", this.buildDirectory.getAbsolutePath());
        variables.put("project.version", this.getProject().getVersion());
        variables.put("url", this.getProject().getUrl());
        return new MapVariableResolver(variables);
    }

    private String getProjectVersion() {
        String version = this.getProject().getVersion().replace('-', '+');
        if (this.timestamped && version.endsWith("+SNAPSHOT")) {
            version = version.substring(0, version.length() - "+SNAPSHOT".length());
            version = version + "~";
            version = version + new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
        }
        return version;
    }

    private boolean isSubmodule() {
        return !this.session.getExecutionRootDirectory().equalsIgnoreCase(this.baseDir.toString());
    }

    private boolean hasMainArtifact() {
        MavenProject project = this.getProject();
        Artifact artifact = project.getArtifact();
        return artifact.getFile() != null && artifact.getFile().isFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        MavenProject project = this.getProject();
        if (this.isSubmodule() && !this.submodules) {
            this.getLog().info((CharSequence)"skipping sub module: jdeb executing at top-level only");
            return;
        }
        this.setData(this.dataSet);
        try {
            MojoConsole infoConsole = new MojoConsole(this.getLog(), this.verbose);
            VariableResolver resolver = this.initializeVariableResolver(new HashMap());
            File debFile = new File(Utils.replaceVariables(resolver, this.deb, this.openReplaceToken, this.closeReplaceToken));
            File controlDirFile = new File(Utils.replaceVariables(resolver, this.controlDir, this.openReplaceToken, this.closeReplaceToken));
            final File installDirFile = new File(Utils.replaceVariables(resolver, this.installDir, this.openReplaceToken, this.closeReplaceToken));
            File changesInFile = new File(Utils.replaceVariables(resolver, this.changesIn, this.openReplaceToken, this.closeReplaceToken));
            File changesOutFile = new File(Utils.replaceVariables(resolver, this.changesOut, this.openReplaceToken, this.closeReplaceToken));
            File changesSaveFile = new File(Utils.replaceVariables(resolver, this.changesSave, this.openReplaceToken, this.closeReplaceToken));
            if (this.dataProducers.isEmpty()) {
                if (!this.hasMainArtifact()) {
                    String packaging = project.getPackaging();
                    if (!"pom".equalsIgnoreCase(packaging)) throw new MojoExecutionException("Nothing to include into the debian package. Did you maybe forget to add a <data> tag or call the plugin directly?");
                    this.getLog().warn((CharSequence)"Creating empty debian package.");
                } else {
                    HashSet<Artifact> artifacts = new HashSet<Artifact>();
                    artifacts.add(project.getArtifact());
                    for (Artifact artifact : project.getArtifacts()) {
                        artifacts.add(artifact);
                    }
                    for (Artifact artifact : project.getAttachedArtifacts()) {
                        artifacts.add(artifact);
                    }
                    for (Artifact artifact : artifacts) {
                        final File file = artifact.getFile();
                        if (file != null) {
                            this.dataProducers.add(new DataProducer(){

                                @Override
                                public void produce(DataConsumer receiver) {
                                    try {
                                        receiver.onEachFile(new FileInputStream(file), new File(installDirFile, file.getName()).getAbsolutePath(), "", "root", 0, "root", 0, 33188, file.length());
                                    }
                                    catch (Exception e) {
                                        DebMojo.this.getLog().error((Throwable)e);
                                    }
                                }
                            });
                            continue;
                        }
                        this.getLog().error((CharSequence)("No file for artifact " + artifact));
                    }
                }
            }
            try {
                DebMaker debMaker = new DebMaker(infoConsole, debFile, controlDirFile, this.dataProducers, resolver);
                if (changesInFile.exists() && changesInFile.canRead()) {
                    debMaker.setChangesIn(changesInFile);
                    debMaker.setChangesOut(changesOutFile);
                    debMaker.setChangesSave(changesSaveFile);
                }
                debMaker.setCompression(this.compression);
                debMaker.makeDeb();
                if (!"true".equalsIgnoreCase(this.attach)) return;
                this.getLog().info((CharSequence)("Attaching created debian archive " + debFile));
                this.projectHelper.attachArtifact(project, this.type, this.classifier, debFile);
                return;
            }
            catch (PackagingException e) {
                this.getLog().error((CharSequence)("Failed to create debian package " + debFile), (Throwable)e);
                throw new MojoExecutionException("Failed to create debian package " + debFile, (Exception)e);
            }
        }
        catch (ParseException e) {
            throw new MojoExecutionException("Failed parsing pattern", (Exception)e);
        }
    }
}

