/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.tar.TarEntry;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.producers.AbstractDataProducer;

public final class DataProducerFile
extends AbstractDataProducer
implements DataProducer {
    private final File file;
    private final String destinationName;

    public DataProducerFile(File pFile, String pDestinationName, String[] pIncludes, String[] pExcludes, Mapper[] pMapper) {
        super(pIncludes, pExcludes, pMapper);
        this.file = pFile;
        this.destinationName = pDestinationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produce(DataConsumer pReceiver) throws IOException {
        String fileName = this.destinationName != null && this.destinationName.trim().length() > 0 ? this.destinationName.trim() : this.file.getName();
        TarEntry entry = new TarEntry(fileName);
        entry.setUserId(0);
        entry.setUserName("root");
        entry.setGroupId(0);
        entry.setGroupName("root");
        entry.setMode(33188);
        entry = this.map(entry);
        entry.setSize(this.file.length());
        FileInputStream inputStream = new FileInputStream(this.file);
        try {
            pReceiver.onEachFile(inputStream, entry.getName(), entry.getLinkName(), entry.getUserName(), entry.getUserId(), entry.getGroupName(), entry.getGroupId(), entry.getMode(), entry.getSize());
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }
}

