/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.types.FileSet;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;

public final class DataProducerFileSet
implements DataProducer {
    private final FileSet fileset;

    public DataProducerFileSet(FileSet pFileset) {
        this.fileset = pFileset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produce(DataConsumer pReceiver) throws IOException {
        String user = "root";
        int uid = 0;
        String group = "root";
        int gid = 0;
        int filemode = 33188;
        int dirmode = 16877;
        String prefix = "";
        if (this.fileset instanceof Tar.TarFileSet) {
            Tar.TarFileSet tarfileset = (Tar.TarFileSet)this.fileset;
            user = tarfileset.getUserName();
            uid = tarfileset.getUid();
            group = tarfileset.getGroup();
            gid = tarfileset.getGid();
            filemode = tarfileset.getMode();
            dirmode = tarfileset.getDirMode(tarfileset.getProject());
            prefix = tarfileset.getPrefix(tarfileset.getProject());
        }
        DirectoryScanner scanner = this.fileset.getDirectoryScanner(this.fileset.getProject());
        scanner.scan();
        File basedir = scanner.getBasedir();
        String[] directories = scanner.getIncludedDirectories();
        for (int i = 0; i < directories.length; ++i) {
            String name = directories[i].replace('\\', '/');
            pReceiver.onEachDir(prefix + "/" + name, null, user, uid, group, gid, dirmode, 0L);
        }
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].replace('\\', '/');
            File file = new File(basedir, name);
            FileInputStream inputStream = new FileInputStream(file);
            try {
                pReceiver.onEachFile(inputStream, prefix + "/" + name, null, user, uid, group, gid, filemode, file.length());
                continue;
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
    }
}

