/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.ParseException;
import org.apache.tools.ant.filters.FixCrLfFilter;
import org.apache.tools.ant.util.ReaderInputStream;
import org.vafer.jdeb.utils.VariableResolver;

public final class Utils {
    public static int copy(InputStream pInput, OutputStream pOutput) throws IOException {
        byte[] buffer = new byte[2048];
        int count = 0;
        int n = 0;
        while (-1 != (n = pInput.read(buffer))) {
            pOutput.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static String toHex(byte[] pBytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pBytes.length; ++i) {
            sb.append(Integer.toHexString(pBytes[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(pBytes[i] & 0xF));
        }
        return sb.toString();
    }

    public static String stripPath(int p, String s) {
        if (p <= 0) {
            return s;
        }
        int x = 0;
        for (int i = 0; i < p; ++i) {
            if ((x = s.indexOf(47, x + 1)) >= 0) continue;
            return s;
        }
        return s.substring(x + 1);
    }

    public static String stripLeadingSlash(String s) {
        if (s == null) {
            return s;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.charAt(0) == '/') {
            return s.substring(1);
        }
        return s;
    }

    public static String replaceVariables(VariableResolver pResolver, String pExpression, String pOpen, String pClose) throws ParseException {
        char[] s = pExpression.toCharArray();
        char[] open = pOpen.toCharArray();
        char[] close = pClose.toCharArray();
        StringBuilder out = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        char[] watch = open;
        int w = 0;
        for (int i = 0; i < s.length; ++i) {
            char c = s[i];
            if (c == watch[w]) {
                if (watch.length != ++w) continue;
                if (watch == open) {
                    out.append((CharSequence)sb);
                    sb = new StringBuilder();
                    watch = close;
                } else if (watch == close) {
                    String variable = pResolver.get(sb.toString());
                    if (variable == null) {
                        throw new ParseException("Failed to resolve variable '" + sb + "'", i);
                    }
                    out.append(variable);
                    sb = new StringBuilder();
                    watch = open;
                }
                w = 0;
                continue;
            }
            if (w > 0) {
                sb.append(watch, 0, w);
            }
            sb.append(c);
            w = 0;
        }
        if (watch == close) {
            out.append(open);
        }
        out.append((CharSequence)sb);
        return out.toString();
    }

    public static byte[] toUnixLineEndings(InputStream input) throws IOException {
        String encoding = "ISO-8859-1";
        FixCrLfFilter filter = new FixCrLfFilter((Reader)new InputStreamReader(input, encoding));
        filter.setEol(FixCrLfFilter.CrLf.newInstance((String)"unix"));
        ByteArrayOutputStream filteredFile = new ByteArrayOutputStream();
        Utils.copy((InputStream)new ReaderInputStream((Reader)filter, encoding), filteredFile);
        return filteredFile.toByteArray();
    }
}

