/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.ar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractArEntry {
    private final int userId;
    private final int groupId;
    private final int mode;

    public AbstractArEntry(int pUserId, int pGroupId, int pMode) {
        this.userId = pUserId;
        this.groupId = pGroupId;
        this.mode = pMode;
    }

    public abstract String getName();

    public abstract long getLength();

    public abstract long getLastModified();

    public abstract InputStream getData() throws IOException;

    long write(OutputStream pOut) throws IOException {
        return this.writeHeader(pOut) + this.writeData(pOut);
    }

    private long write(String pData, OutputStream pOut) throws IOException {
        byte[] data = pData.getBytes("ascii");
        pOut.write(data);
        return data.length;
    }

    private long fill(long pOffset, long pNewOffset, char pFill, OutputStream pOut) throws IOException {
        long diff = pNewOffset - pOffset;
        if (diff > 0L) {
            int i = 0;
            while ((long)i < diff) {
                pOut.write(pFill);
                ++i;
            }
        }
        return pNewOffset;
    }

    private long writeHeader(OutputStream pOut) throws IOException {
        long offset = 0L;
        String n = this.getName();
        if (n.length() > 16) {
            throw new IOException("filename too long");
        }
        offset += this.write(n, pOut);
        offset = this.fill(offset, 16L, ' ', pOut);
        String m = "" + this.getLastModified() / 1000L;
        if (m.length() > 12) {
            throw new IOException("modified too long");
        }
        offset += this.write(m, pOut);
        offset = this.fill(offset, 28L, ' ', pOut);
        String u = "" + this.userId;
        if (u.length() > 6) {
            throw new IOException("userid too long");
        }
        offset += this.write(u, pOut);
        offset = this.fill(offset, 34L, ' ', pOut);
        String g = "" + this.groupId;
        if (g.length() > 6) {
            throw new IOException("groupid too long");
        }
        offset += this.write(g, pOut);
        offset = this.fill(offset, 40L, ' ', pOut);
        String fm = "" + Integer.toString(this.mode, 8);
        if (fm.length() > 8) {
            throw new IOException("filemode too long");
        }
        offset += this.write(fm, pOut);
        offset = this.fill(offset, 48L, ' ', pOut);
        String s = "" + this.getLength();
        if (s.length() > 10) {
            throw new IOException("size too long");
        }
        offset += this.write(s, pOut);
        offset = this.fill(offset, 58L, ' ', pOut);
        return offset += this.write("`\n", pOut);
    }

    private long writeData(OutputStream pOut) throws IOException {
        byte[] buffer = new byte[2048];
        InputStream input = this.getData();
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            pOut.write(buffer, 0, n);
            count += (long)n;
        }
        if (count % 2L != 0L) {
            pOut.write(10);
            ++count;
        }
        input.close();
        return count;
    }
}

