/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.changes;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class ChangeSet {
    private final String packageName;
    private final String version;
    private final Date date;
    private final String distribution;
    private final String urgency;
    private final String changedBy;
    private final String[] changes;

    public ChangeSet(String pPackageName, String pVersion, Date pDate, String pDistribution, String pUrgency, String pChangedBy, String[] pChanges) {
        this.changes = pChanges;
        this.packageName = pPackageName;
        this.version = pVersion;
        this.date = pDate;
        this.distribution = pDistribution;
        this.urgency = pUrgency;
        this.changedBy = pChangedBy;
    }

    public static DateFormat createDateForma() {
        return new SimpleDateFormat("HH:mm dd.MM.yyyy");
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getUrgency() {
        return this.urgency;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public String[] getChanges() {
        return this.changes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" ").append(this.getPackage()).append(" (").append(this.getVersion()).append(") ");
        sb.append(this.getDistribution()).append("; urgency=").append(this.getUrgency()).append("\n");
        for (int i = 0; i < this.changes.length; ++i) {
            sb.append(" * ").append(this.changes[i]).append("\n");
        }
        return sb.toString();
    }
}

