/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.mapping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.tar.TarEntry;
import org.vafer.jdeb.mapping.Mapper;

public final class LsMapper
implements Mapper {
    private final Map mapping;
    private final Pattern basePattern = Pattern.compile("^\\./(.*):$");
    private final Pattern totalPattern = Pattern.compile("^total ([0-9]+)$");
    private final Pattern dirPattern = Pattern.compile("^d([rwx-]{9})\\s+([0-9]+)\\s+(\\S*)\\s+(\\S*)\\s+([0-9]+)\\s+(.*)\\s+[\\.]{1,2}$");
    private final Pattern filePattern = Pattern.compile("^([d-])([rwx-]{9})\\s+([0-9]+)\\s+(\\S*)\\s+(\\S*)\\s+([0-9]+)\\s+(.*)\\s+(.*)$");
    private final Pattern newlinePattern = Pattern.compile("$");

    public LsMapper(InputStream pInput) throws IOException, ParseError {
        this.mapping = this.parse(pInput);
    }

    private String readBase(BufferedReader reader) throws IOException, ParseError {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        Matcher matcher = this.basePattern.matcher(line);
        if (!matcher.matches()) {
            throw new ParseError("expected base line but got \"" + line + "\"");
        }
        return matcher.group(1);
    }

    private String readTotal(BufferedReader reader) throws IOException, ParseError {
        String line = reader.readLine();
        Matcher matcher = this.totalPattern.matcher(line);
        if (!matcher.matches()) {
            throw new ParseError("expected total line but got \"" + line + "\"");
        }
        return matcher.group(1);
    }

    private TarEntry readDir(BufferedReader reader, String base) throws IOException, ParseError {
        String current = reader.readLine();
        Matcher currentMatcher = this.dirPattern.matcher(current);
        if (!currentMatcher.matches()) {
            throw new ParseError("expected dirline but got \"" + current + "\"");
        }
        String parent = reader.readLine();
        Matcher parentMatcher = this.dirPattern.matcher(parent);
        if (!parentMatcher.matches()) {
            throw new ParseError("expected dirline but got \"" + parent + "\"");
        }
        TarEntry entry = new TarEntry(base);
        entry.setMode(this.convertModeFromString(currentMatcher.group(1)));
        entry.setUserName(currentMatcher.group(3));
        entry.setGroupName(currentMatcher.group(4));
        return entry;
    }

    private int convertModeFromString(String mode) {
        char[] m = mode.toCharArray();
        int sum = 0;
        int bit = 1;
        for (int i = m.length - 1; i >= 0; --i) {
            if (m[i] != '-') {
                sum += bit;
            }
            bit += bit;
        }
        return sum;
    }

    private TarEntry readFile(BufferedReader reader, String base) throws IOException, ParseError {
        Matcher currentMatcher;
        String type;
        do {
            String line;
            if ((line = reader.readLine()) == null) {
                return null;
            }
            currentMatcher = this.filePattern.matcher(line);
            if (currentMatcher.matches()) continue;
            Matcher newlineMatcher = this.newlinePattern.matcher(line);
            if (newlineMatcher.matches()) {
                return null;
            }
            throw new ParseError("expected file line but got \"" + line + "\"");
        } while (!(type = currentMatcher.group(1)).startsWith("-"));
        TarEntry entry = new TarEntry(base + "/" + currentMatcher.group(8));
        entry.setMode(this.convertModeFromString(currentMatcher.group(2)));
        entry.setUserName(currentMatcher.group(4));
        entry.setGroupName(currentMatcher.group(5));
        return entry;
    }

    private Map parse(InputStream pInput) throws IOException, ParseError {
        String base;
        HashMap<String, TarEntry> mapping = new HashMap<String, TarEntry>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(pInput));
        while ((base = this.readBase(reader)) != null) {
            TarEntry file;
            this.readTotal(reader);
            TarEntry dir = this.readDir(reader, base);
            mapping.put(dir.getName(), dir);
            while ((file = this.readFile(reader, base)) != null) {
                mapping.put(file.getName(), file);
            }
        }
        return mapping;
    }

    public TarEntry map(TarEntry pEntry) {
        TarEntry entry = (TarEntry)this.mapping.get(pEntry.getName());
        if (entry != null) {
            TarEntry newEntry = new TarEntry(entry.getName());
            newEntry.setUserId(pEntry.getUserId());
            newEntry.setGroupId(pEntry.getGroupId());
            newEntry.setUserName(pEntry.getUserName());
            newEntry.setGroupName(pEntry.getGroupName());
            newEntry.setMode(pEntry.getMode());
            newEntry.setSize(pEntry.getSize());
            return entry;
        }
        return pEntry;
    }

    public static final class ParseError
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseError() {
        }

        public ParseError(String message, Throwable cause) {
            super(message, cause);
        }

        public ParseError(String message) {
            super(message);
        }

        public ParseError(Throwable cause) {
            super(cause);
        }
    }
}

