/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.tools.ant.DirectoryScanner;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.producers.AbstractDataProducer;
import org.vafer.jdeb.utils.Utils;

public final class DataProducerDirectory
extends AbstractDataProducer
implements DataProducer {
    private final DirectoryScanner scanner = new DirectoryScanner();

    public DataProducerDirectory(File pDir, String[] pIncludes, String[] pExcludes, Mapper pMapper) {
        super(pIncludes, pExcludes, pMapper);
        this.scanner.setBasedir(pDir);
        this.scanner.setIncludes(pIncludes);
        this.scanner.setExcludes(pExcludes);
        this.scanner.setCaseSensitive(true);
        this.scanner.setFollowSymlinks(true);
    }

    public void produce(DataConsumer receiver) {
        try {
            this.scanner.scan();
            File baseDir = this.scanner.getBasedir();
            String[] dirs = this.scanner.getIncludedDirectories();
            for (int i = 0; i < dirs.length; ++i) {
                File file = new File(baseDir, dirs[i]);
                String dirname = this.getFilename(baseDir, file);
                if ("".equals(dirname)) continue;
                receiver.onEachDir(dirname, "", "root", 0, "root", 0, 16877, file.length());
            }
            String[] files = this.scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(baseDir, files[i]);
                String filename = this.getFilename(baseDir, file);
                receiver.onEachFile(new FileInputStream(file), filename, "", "root", 0, "root", 0, 33188, file.length());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getFilename(File root, File file) {
        String relativeFilename = file.getAbsolutePath().substring(root.getAbsolutePath().length());
        return Utils.stripLeadingSlash(relativeFilename);
    }
}

