/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.PackagingException;
import org.vafer.jdeb.ar.ArEntry;
import org.vafer.jdeb.ar.ArOutputStream;
import org.vafer.jdeb.changes.ChangeSet;
import org.vafer.jdeb.changes.ChangesProvider;
import org.vafer.jdeb.descriptors.AbstractDescriptor;
import org.vafer.jdeb.descriptors.ChangesDescriptor;
import org.vafer.jdeb.descriptors.InvalidDescriptorException;
import org.vafer.jdeb.descriptors.PackageDescriptor;
import org.vafer.jdeb.signing.SigningUtils;
import org.vafer.jdeb.utils.InformationOutputStream;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

public class Processor {
    private final Console console;
    private final VariableResolver resolver;

    public Processor(Console pConsole, VariableResolver pResolver) {
        this.console = pConsole;
        this.resolver = pResolver;
    }

    private void addTo(ArOutputStream pOutput, String pName, String pContent) throws IOException {
        byte[] content = pContent.getBytes();
        pOutput.putNextEntry(new ArEntry(pName, content.length));
        pOutput.write(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTo(ArOutputStream pOutput, String pName, File pContent) throws IOException {
        pOutput.putNextEntry(new ArEntry(pName, pContent.length()));
        FileInputStream input = new FileInputStream(pContent);
        try {
            Utils.copy(input, pOutput);
        }
        finally {
            ((InputStream)input).close();
        }
    }

    public PackageDescriptor createDeb(File[] pControlFiles, DataProducer[] pData, File pOutput) throws PackagingException, InvalidDescriptorException {
        File tempData = null;
        File tempControl = null;
        try {
            tempData = File.createTempFile("deb", "data");
            tempControl = File.createTempFile("deb", "control");
            this.console.println("Building data");
            StringBuffer md5s = new StringBuffer();
            BigInteger size = this.buildData(pData, tempData, md5s);
            this.console.println("Building control");
            PackageDescriptor packageDescriptor = this.buildControl(pControlFiles, size, md5s, tempControl);
            if (!packageDescriptor.isValid()) {
                throw new InvalidDescriptorException(packageDescriptor);
            }
            InformationOutputStream output = new InformationOutputStream(new FileOutputStream(pOutput), MessageDigest.getInstance("MD5"));
            ArOutputStream ar = new ArOutputStream(output);
            this.addTo(ar, "debian-binary", "2.0\n");
            this.addTo(ar, "control.tar.gz", tempControl);
            this.addTo(ar, "data.tar.gz", tempData);
            ar.close();
            packageDescriptor.set("MD5", output.getMd5());
            packageDescriptor.set("Size", "" + output.getSize());
            packageDescriptor.set("File", pOutput.getName());
            PackageDescriptor packageDescriptor2 = packageDescriptor;
            return packageDescriptor2;
        }
        catch (InvalidDescriptorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PackagingException("Could not create deb package", e);
        }
        finally {
            if (tempData != null) {
                tempData.delete();
            }
            if (tempControl != null) {
                tempControl.delete();
            }
        }
    }

    public ChangesDescriptor createChanges(PackageDescriptor pPackageDescriptor, ChangesProvider pChangesProvider, InputStream pRing, String pKey, String pPassphrase, OutputStream pOutput) throws IOException, InvalidDescriptorException {
        ChangeSet[] changeSets = pChangesProvider.getChangesSets();
        ChangesDescriptor changesDescriptor = new ChangesDescriptor(pPackageDescriptor, changeSets);
        changesDescriptor.set("Format", "1.7");
        if (changesDescriptor.get("Binary") == null) {
            changesDescriptor.set("Binary", changesDescriptor.get("Package"));
        }
        if (changesDescriptor.get("Source") == null) {
            changesDescriptor.set("Source", changesDescriptor.get("Package"));
        }
        if (changesDescriptor.get("Description") == null) {
            changesDescriptor.set("Description", "update to " + changesDescriptor.get("Version"));
        }
        StringBuffer files = new StringBuffer("\n");
        files.append(' ').append(changesDescriptor.get("MD5"));
        files.append(' ').append(changesDescriptor.get("Size"));
        files.append(' ').append(changesDescriptor.get("Section"));
        files.append(' ').append(changesDescriptor.get("Priority"));
        files.append(' ').append(changesDescriptor.get("File"));
        changesDescriptor.set("Files", files.toString());
        if (!changesDescriptor.isValid()) {
            throw new InvalidDescriptorException(changesDescriptor);
        }
        String changes = changesDescriptor.toString();
        byte[] changesBytes = changes.getBytes("UTF-8");
        if (pRing == null || pKey == null || pPassphrase == null) {
            pOutput.write(changesBytes);
            pOutput.close();
            return changesDescriptor;
        }
        this.console.println("Signing changes with key " + pKey);
        ByteArrayInputStream input = new ByteArrayInputStream(changesBytes);
        try {
            SigningUtils.clearSign(input, pRing, pKey, pPassphrase, pOutput);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pOutput.close();
        return changesDescriptor;
    }

    private PackageDescriptor buildControl(File[] pControlFiles, BigInteger pDataSize, StringBuffer pChecksums, File pOutput) throws FileNotFoundException, IOException, ParseException {
        AbstractDescriptor packageDescriptor = null;
        TarOutputStream outputStream = new TarOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(pOutput)));
        outputStream.setLongFileMode(2);
        for (int i = 0; i < pControlFiles.length; ++i) {
            File file = pControlFiles[i];
            if (file.isDirectory()) continue;
            TarEntry entry = new TarEntry(file);
            String name = file.getName();
            entry.setName(name);
            if ("control".equals(name)) {
                packageDescriptor = new PackageDescriptor(new FileInputStream(file), this.resolver);
                if (packageDescriptor.get("Date") == null) {
                    packageDescriptor.set("Date", new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(new Date()));
                }
                if (packageDescriptor.get("Distribution") == null) {
                    packageDescriptor.set("Distribution", "unknown");
                }
                if (packageDescriptor.get("Urgency") == null) {
                    packageDescriptor.set("Urgency", "low");
                }
                String debFullName = System.getenv("DEBFULLNAME");
                String debEmail = System.getenv("DEBEMAIL");
                if (debFullName == null || debEmail == null) continue;
                packageDescriptor.set("Maintainer", debFullName + " <" + debEmail + ">");
                this.console.println("Using maintainer from the environment variables.");
                continue;
            }
            FileInputStream inputStream = new FileInputStream(file);
            outputStream.putNextEntry(entry);
            Utils.copy(inputStream, (OutputStream)outputStream);
            outputStream.closeEntry();
            ((InputStream)inputStream).close();
        }
        if (packageDescriptor == null) {
            throw new FileNotFoundException("No control file in " + Arrays.toString(pControlFiles));
        }
        packageDescriptor.set("Installed-Size", pDataSize.toString());
        Processor.addEntry("control", ((PackageDescriptor)packageDescriptor).toString(), outputStream);
        Processor.addEntry("md5sums", pChecksums.toString(), outputStream);
        outputStream.close();
        return packageDescriptor;
    }

    private BigInteger buildData(DataProducer[] pData, File pOutput, final StringBuffer pChecksums) throws NoSuchAlgorithmException, IOException {
        final TarOutputStream outputStream = new TarOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(pOutput)));
        outputStream.setLongFileMode(2);
        final MessageDigest digest = MessageDigest.getInstance("MD5");
        final Total dataSize = new Total();
        DataConsumer receiver = new DataConsumer(){

            public void onEachDir(String dirname, String linkname, String user, int uid, String group, int gid, int mode, long size) throws IOException {
                if (!dirname.endsWith("/")) {
                    dirname = dirname + "/";
                }
                if (!dirname.startsWith("/")) {
                    dirname = "/" + dirname;
                }
                TarEntry entry = new TarEntry(dirname);
                entry.setUserName(user);
                entry.setUserId(uid);
                entry.setGroupName(group);
                entry.setGroupId(gid);
                entry.setMode(mode);
                entry.setSize(0L);
                outputStream.putNextEntry(entry);
                Processor.this.console.println("dir: " + dirname);
                outputStream.closeEntry();
            }

            public void onEachFile(InputStream inputStream, String filename, String linkname, String user, int uid, String group, int gid, int mode, long size) throws IOException {
                if (!filename.startsWith("/")) {
                    filename = "/" + filename;
                }
                TarEntry entry = new TarEntry(filename);
                entry.setUserName(user);
                entry.setUserId(uid);
                entry.setGroupName(group);
                entry.setGroupId(gid);
                entry.setMode(mode);
                entry.setSize(size);
                outputStream.putNextEntry(entry);
                dataSize.add(size);
                digest.reset();
                Utils.copy(inputStream, new DigestOutputStream((OutputStream)outputStream, digest));
                String md5 = Utils.toHex(digest.digest());
                outputStream.closeEntry();
                Processor.this.console.println("file:" + entry.getName() + " size:" + entry.getSize() + " mode:" + entry.getMode() + " linkname:" + entry.getLinkName() + " username:" + entry.getUserName() + " userid:" + entry.getUserId() + " groupname:" + entry.getGroupName() + " groupid:" + entry.getGroupId() + " modtime:" + entry.getModTime() + " md5: " + md5);
                pChecksums.append(md5).append(" ").append(entry.getName()).append('\n');
            }
        };
        for (int i = 0; i < pData.length; ++i) {
            DataProducer data = pData[i];
            data.produce(receiver);
        }
        outputStream.close();
        this.console.println("Total size: " + dataSize);
        return dataSize.count;
    }

    private static void addEntry(String pName, String pContent, TarOutputStream pOutput) throws IOException {
        byte[] data = pContent.getBytes("UTF-8");
        TarEntry entry = new TarEntry(pName);
        entry.setSize((long)data.length);
        pOutput.putNextEntry(entry);
        pOutput.write(data);
        pOutput.closeEntry();
    }

    private static final class Total {
        private BigInteger count = BigInteger.valueOf(0L);

        private Total() {
        }

        public void add(long size) {
            this.count = this.count.add(BigInteger.valueOf(size));
        }

        public String toString() {
            return "" + this.count;
        }

        public BigInteger toBigInteger() {
            return this.count;
        }
    }
}

