/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.tools.ant.types.PatternSet;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.ant.Mapper;
import org.vafer.jdeb.producers.DataProducerArchive;
import org.vafer.jdeb.producers.DataProducerDirectory;

public final class Data
extends PatternSet
implements DataProducer {
    private File src;
    private Collection mapperWrapper = new ArrayList();

    public void setSrc(File pSrc) {
        this.src = pSrc;
    }

    public void addMapper(Mapper pMapper) {
        this.mapperWrapper.add(pMapper);
    }

    public void produce(DataConsumer pReceiver) {
        if (!this.src.exists()) {
            System.err.println("ATTENTION: \"" + this.src + " \" is not existing. Ignoring unexisting data providers is deprecated. This will fail your build in later releases.");
            return;
        }
        org.vafer.jdeb.mapping.Mapper[] mappers = new org.vafer.jdeb.mapping.Mapper[this.mapperWrapper.size()];
        Iterator it = this.mapperWrapper.iterator();
        for (int i = 0; i < mappers.length; ++i) {
            mappers[i] = ((Mapper)it.next()).createMapper();
        }
        if (this.src.isFile()) {
            new DataProducerArchive(this.src, this.getIncludePatterns(this.getProject()), this.getExcludePatterns(this.getProject()), mappers).produce(pReceiver);
        } else {
            new DataProducerDirectory(this.src, this.getIncludePatterns(this.getProject()), this.getExcludePatterns(this.getProject()), mappers).produce(pReceiver);
        }
    }
}

