/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.Processor;
import org.vafer.jdeb.ant.Data;
import org.vafer.jdeb.changes.TextfileChangesProvider;
import org.vafer.jdeb.descriptors.PackageDescriptor;

public class DebAntTask
extends MatchingTask {
    private File deb;
    private File control;
    private File keyring;
    private File changesIn;
    private File changesOut;
    private File changesSave;
    private String key;
    private String passphrase;
    private Collection dataProducers = new ArrayList();

    public void setDestfile(File deb) {
        this.deb = deb;
    }

    public void setControl(File control) {
        this.control = control;
    }

    public void setChangesIn(File changes) {
        this.changesIn = changes;
    }

    public void setChangesOut(File changes) {
        this.changesOut = changes;
    }

    public void setChangesSave(File changes) {
        this.changesSave = changes;
    }

    public void setKeyring(File keyring) {
        this.keyring = keyring;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public void addData(Data data) {
        this.dataProducers.add(data);
    }

    private boolean isPossibleOutput(File file) {
        if (file.exists()) {
            return file.isFile() && file.canWrite();
        }
        return true;
    }

    public void execute() {
        TextfileChangesProvider changesProvider;
        PackageDescriptor packageDescriptor;
        if (this.control == null || !this.control.isDirectory()) {
            throw new BuildException("You need to point the 'control' attribute to the control directory.");
        }
        if (this.changesIn != null) {
            if (!this.changesIn.isFile() || !this.changesIn.canRead()) {
                throw new BuildException("The 'changesIn' attribute needs to point to a readable file.");
            }
            if (this.changesOut == null) {
                throw new BuildException("A 'changesIn' without a 'changesOut' does not make much sense.");
            }
            if (!this.isPossibleOutput(this.changesOut)) {
                throw new BuildException("Cannot write the output for 'changesOut' to " + this.changesOut);
            }
            if (this.changesSave != null && !this.isPossibleOutput(this.changesSave)) {
                throw new BuildException("Cannot write the output for 'changesSave' to " + this.changesSave);
            }
        } else if (this.changesOut != null || this.changesSave != null) {
            throw new BuildException("The 'changesOut' or 'changesSave' attributes may only be used when there is a 'changesIn' specified.");
        }
        if (this.dataProducers.size() == 0) {
            throw new BuildException("You need to provide at least one reference to a tgz or directory with data.");
        }
        if (this.deb == null) {
            throw new BuildException("You need to point the 'destfile' attribute to where the deb is supposed to be created.");
        }
        File[] controlFiles = this.control.listFiles();
        DataProducer[] data = new DataProducer[this.dataProducers.size()];
        this.dataProducers.toArray(data);
        Processor processor = new Processor(new Console(){

            public void println(String s) {
                DebAntTask.this.log(s);
            }
        }, null);
        try {
            packageDescriptor = processor.createDeb(controlFiles, data, this.deb);
            this.log("Created " + this.deb);
        }
        catch (Exception e) {
            this.log("Failed to create debian package " + this.deb + e);
            e.printStackTrace();
            return;
        }
        try {
            if (this.changesOut == null) {
                return;
            }
            changesProvider = new TextfileChangesProvider(new FileInputStream(this.changesIn), packageDescriptor);
            processor.createChanges(packageDescriptor, changesProvider, this.keyring != null ? new FileInputStream(this.keyring) : null, this.key, this.passphrase, new FileOutputStream(this.changesOut));
            this.log("Created changes file " + this.changesOut);
        }
        catch (Exception e) {
            this.log("Failed to create debian changes file " + this.changesOut);
            e.printStackTrace();
            return;
        }
        try {
            if (this.changesSave == null) {
                return;
            }
            changesProvider.save(new FileOutputStream(this.changesSave));
            this.log("Saved changes to file " + this.changesSave);
        }
        catch (Exception e) {
            this.log("Failed to save debian changes file " + this.changesSave);
            e.printStackTrace();
            return;
        }
    }
}

