/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.ar;

import java.io.IOException;
import java.io.InputStream;
import org.vafer.jdeb.ar.ArEntry;

public class ArInputStream
extends InputStream {
    private final InputStream input;
    private long offset = 0L;

    public ArInputStream(InputStream pInput) {
        this.input = pInput;
    }

    public ArEntry getNextEntry() throws IOException {
        if (this.offset == 0L) {
            byte[] expected = "!<arch>\n".getBytes();
            byte[] realized = new byte[expected.length];
            int read = this.input.read(realized);
            if (read != expected.length) {
                throw new IOException("failed to read header");
            }
            for (int i = 0; i < expected.length; ++i) {
                if (expected[i] == realized[i]) continue;
                throw new IOException("invalid header " + new String(realized));
            }
        }
        if (this.input.available() == 0) {
            return null;
        }
        if (this.offset % 2L != 0L) {
            this.read();
        }
        byte[] name = new byte[16];
        byte[] lastmodified = new byte[12];
        byte[] userid = new byte[6];
        byte[] groupid = new byte[6];
        byte[] filemode = new byte[8];
        byte[] length = new byte[10];
        this.read(name);
        this.read(lastmodified);
        this.read(userid);
        this.read(groupid);
        this.read(filemode);
        this.read(length);
        byte[] expected = "`\n".getBytes();
        byte[] realized = new byte[expected.length];
        int read = this.input.read(realized);
        if (read != expected.length) {
            throw new IOException("failed to read entry header");
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == realized[i]) continue;
            throw new IOException("invalid entry header. not read the content?");
        }
        return new ArEntry(new String(name).trim(), Long.parseLong(new String(length).trim()));
    }

    public int read() throws IOException {
        int ret = this.input.read();
        ++this.offset;
        return ret;
    }
}

