/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.ar;

import java.io.IOException;
import java.io.OutputStream;
import org.vafer.jdeb.ar.ArEntry;

public class ArOutputStream
extends OutputStream {
    private final OutputStream out;
    private long archiveOffset = 0L;
    private long entryOffset = 0L;
    private ArEntry prevEntry;

    public ArOutputStream(OutputStream pOut) {
        this.out = pOut;
    }

    private long writeArchiveHeader() throws IOException {
        String header = "!<arch>\n";
        this.out.write("!<arch>\n".getBytes());
        return "!<arch>\n".length();
    }

    private void closeEntry() throws IOException {
        if (this.entryOffset % 2L != 0L) {
            this.write(10);
            ++this.archiveOffset;
        }
    }

    public void putNextEntry(ArEntry pEntry) throws IOException {
        if (this.prevEntry == null) {
            this.archiveOffset += this.writeArchiveHeader();
        } else {
            if (this.prevEntry.getLength() != this.entryOffset) {
                throw new IOException("length does not match entry (" + this.prevEntry.getLength() + " != " + this.entryOffset);
            }
            this.closeEntry();
        }
        this.prevEntry = pEntry;
        this.archiveOffset += this.writeEntryHeader(pEntry);
        this.entryOffset = 0L;
    }

    private long fill(long pOffset, long pNewOffset, char pFill) throws IOException {
        long diff = pNewOffset - pOffset;
        if (diff > 0L) {
            int i = 0;
            while ((long)i < diff) {
                this.write(pFill);
                ++i;
            }
        }
        return pNewOffset;
    }

    private long write(String data) throws IOException {
        byte[] bytes = data.getBytes("ascii");
        this.write(bytes);
        return bytes.length;
    }

    private long writeEntryHeader(ArEntry pEntry) throws IOException {
        long offset = 0L;
        String n = pEntry.getName();
        if (n.length() > 16) {
            throw new IOException("filename too long");
        }
        offset += this.write(n);
        offset = this.fill(offset, 16L, ' ');
        String m = "" + pEntry.getLastModified() / 1000L;
        if (m.length() > 12) {
            throw new IOException("modified too long");
        }
        offset += this.write(m);
        offset = this.fill(offset, 28L, ' ');
        String u = "" + pEntry.getUserId();
        if (u.length() > 6) {
            throw new IOException("userid too long");
        }
        offset += this.write(u);
        offset = this.fill(offset, 34L, ' ');
        String g = "" + pEntry.getGroupId();
        if (g.length() > 6) {
            throw new IOException("groupid too long");
        }
        offset += this.write(g);
        offset = this.fill(offset, 40L, ' ');
        String fm = "" + Integer.toString(pEntry.getMode(), 8);
        if (fm.length() > 8) {
            throw new IOException("filemode too long");
        }
        offset += this.write(fm);
        offset = this.fill(offset, 48L, ' ');
        String s = "" + pEntry.getLength();
        if (s.length() > 10) {
            throw new IOException("size too long");
        }
        offset += this.write(s);
        offset = this.fill(offset, 58L, ' ');
        return offset += this.write("`\n");
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.entryOffset;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.entryOffset += (long)len;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.entryOffset += (long)b.length;
    }

    public void close() throws IOException {
        this.closeEntry();
        this.out.close();
        this.prevEntry = null;
    }
}

