/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.ParseException;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.Processor;
import org.vafer.jdeb.changes.TextfileChangesProvider;
import org.vafer.jdeb.descriptors.PackageDescriptor;
import org.vafer.jdeb.maven.AbstractPluginMojo;
import org.vafer.jdeb.utils.MapVariableResolver;
import org.vafer.jdeb.utils.Utils;

public final class DebMojo
extends AbstractPluginMojo {
    private MavenProjectHelper projectHelper;
    private String namePattern;
    private File deb;
    private File controlDir;
    private File changesIn = null;
    private File changesOut = null;
    private File changesSave = null;
    private File keyring = null;
    private String key = null;
    private String passphrase = null;
    private String defaultPath = "/srv/jetty/www";
    private DataProducer[] dataProducers = null;

    public void execute() throws MojoExecutionException {
        TextfileChangesProvider changesProvider;
        PackageDescriptor packageDescriptor;
        File f;
        String changesName;
        String debName;
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("name", this.getProject().getName());
        variables.put("artifactId", this.getProject().getArtifactId());
        variables.put("groupId", this.getProject().getGroupId());
        variables.put("version", this.getProject().getVersion().replace('-', '+'));
        variables.put("description", this.getProject().getDescription());
        variables.put("extension", "deb");
        MapVariableResolver resolver = new MapVariableResolver(variables);
        try {
            debName = Utils.replaceVariables(resolver, this.namePattern, "[[", "]]");
            variables.put("extension", "changes");
            changesName = Utils.replaceVariables(resolver, this.namePattern, "[[", "]]");
        }
        catch (ParseException e) {
            throw new MojoExecutionException("Failed parsing artifact name pattern", (Exception)e);
        }
        if (this.deb == null) {
            this.deb = new File(this.buildDirectory, debName);
        }
        if (this.changesIn == null && (f = new File(this.getProject().getBasedir(), "CHANGES.txt")).exists() && f.isFile() && f.canRead()) {
            this.changesIn = f;
        }
        if (this.changesOut == null) {
            this.changesOut = new File(this.buildDirectory, changesName);
        }
        if (this.controlDir == null) {
            this.controlDir = new File(this.getProject().getBasedir(), "src/deb/control");
            this.getLog().info((CharSequence)("Using default path to control directory " + this.controlDir));
        }
        if (!this.controlDir.exists() || !this.controlDir.isDirectory()) {
            throw new MojoExecutionException(this.controlDir + " needs to be a directory");
        }
        File controlFile = new File(this.controlDir, "control");
        if (!(controlFile.exists() && controlFile.isFile() && controlFile.canRead())) {
            throw new MojoExecutionException(controlFile + " is mandatory");
        }
        final File file = this.getProject().getArtifact().getFile();
        File[] controlFiles = this.controlDir.listFiles();
        if (this.dataProducers == null) {
            this.dataProducers = new DataProducer[]{new DataProducer(){

                public void produce(DataConsumer receiver) {
                    try {
                        receiver.onEachFile(new FileInputStream(file), new File(new File(DebMojo.this.defaultPath), file.getName()).getAbsolutePath(), "", "root", 0, "root", 0, 33188, file.length());
                    }
                    catch (Exception e) {
                        DebMojo.this.getLog().error((Throwable)e);
                    }
                }
            }};
        }
        Processor processor = new Processor(new Console(){

            public void println(String s) {
                DebMojo.this.getLog().info((CharSequence)s);
            }
        }, resolver);
        try {
            packageDescriptor = processor.createDeb(controlFiles, this.dataProducers, this.deb);
            this.getLog().info((CharSequence)("Attaching created debian archive " + this.deb));
            this.projectHelper.attachArtifact(this.getProject(), "deb-archive", this.deb.getName(), this.deb);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to create debian package " + this.deb), (Throwable)e);
            throw new MojoExecutionException("Failed to create debian package " + this.deb, e);
        }
        if (this.changesIn == null) {
            return;
        }
        try {
            changesProvider = new TextfileChangesProvider(new FileInputStream(this.changesIn), packageDescriptor);
            processor.createChanges(packageDescriptor, changesProvider, this.keyring != null ? new FileInputStream(this.keyring) : null, this.key, this.passphrase, new FileOutputStream(this.changesOut));
            this.getLog().info((CharSequence)("Attaching created debian changes file " + this.changesOut));
            this.projectHelper.attachArtifact(this.getProject(), "deb-changes", this.changesOut.getName(), this.changesOut);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to create debian changes file " + this.changesOut), (Throwable)e);
            throw new MojoExecutionException("Failed to create debian changes file " + this.changesOut, e);
        }
        try {
            if (this.changesSave == null) {
                return;
            }
            changesProvider.save(new FileOutputStream(this.changesSave));
            this.getLog().info((CharSequence)("Saved release information to file " + this.changesSave));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to save release information to file " + this.changesSave));
            throw new MojoExecutionException("Failed to save release information to file " + this.changesSave, e);
        }
    }
}

