/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.producers.AbstractDataProducer;

public final class DataProducerArchive
extends AbstractDataProducer
implements DataProducer {
    private final File archive;

    public DataProducerArchive(File pArchive, String[] pIncludes, String[] pExcludes, Mapper[] pMappers) {
        super(pIncludes, pExcludes, pMappers);
        this.archive = pArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce(DataConsumer receiver) {
        TarInputStream archiveInputStream = null;
        try {
            TarEntry entry;
            archiveInputStream = new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(this.archive)));
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                if (!this.isIncluded(entry.getName())) continue;
                if ((entry = this.map(entry)).isDirectory()) {
                    receiver.onEachDir(entry.getName(), entry.getLinkName(), entry.getUserName(), entry.getUserId(), entry.getGroupName(), entry.getGroupId(), entry.getMode(), entry.getSize());
                    continue;
                }
                receiver.onEachFile((InputStream)archiveInputStream, entry.getName(), entry.getLinkName(), entry.getUserName(), entry.getUserId(), entry.getGroupName(), entry.getGroupId(), entry.getMode(), entry.getSize());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (archiveInputStream != null) {
                try {
                    archiveInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

