/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.tools.ant.types.PatternSet;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.ant.Mapper;
import org.vafer.jdeb.producers.DataProducerArchive;
import org.vafer.jdeb.producers.DataProducerDirectory;
import org.vafer.jdeb.producers.DataProducerFile;

public final class Data
extends PatternSet
implements DataProducer {
    private final Collection<Mapper> mapperWrapper = new ArrayList<Mapper>();
    private File src;
    private String type;
    private String destinationName;

    public void setSrc(File src) {
        this.src = src;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDst(String destinationName) {
        this.destinationName = destinationName;
    }

    public void addMapper(Mapper mapper) {
        this.mapperWrapper.add(mapper);
    }

    @Override
    public void produce(DataConsumer pReceiver) throws IOException {
        if (this.src == null || !this.src.exists()) {
            throw new FileNotFoundException("Data source not found : " + this.src);
        }
        org.vafer.jdeb.mapping.Mapper[] mappers = new org.vafer.jdeb.mapping.Mapper[this.mapperWrapper.size()];
        Iterator<Mapper> it = this.mapperWrapper.iterator();
        for (int i = 0; i < mappers.length; ++i) {
            mappers[i] = it.next().createMapper();
        }
        if ("file".equalsIgnoreCase(this.type)) {
            new DataProducerFile(this.src, this.destinationName, this.getIncludePatterns(this.getProject()), this.getExcludePatterns(this.getProject()), mappers).produce(pReceiver);
        } else if ("archive".equalsIgnoreCase(this.type)) {
            new DataProducerArchive(this.src, this.getIncludePatterns(this.getProject()), this.getExcludePatterns(this.getProject()), mappers).produce(pReceiver);
        } else if ("directory".equalsIgnoreCase(this.type)) {
            new DataProducerDirectory(this.src, this.getIncludePatterns(this.getProject()), this.getExcludePatterns(this.getProject()), mappers).produce(pReceiver);
        }
    }
}

