/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.descriptors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

public abstract class AbstractDescriptor {
    protected final Map<String, String> values = new LinkedHashMap<String, String>();
    protected final VariableResolver resolver;
    private static String openToken = "[[";
    private static String closeToken = "]]";

    public AbstractDescriptor(VariableResolver pResolver) {
        this.resolver = pResolver;
    }

    public AbstractDescriptor(AbstractDescriptor pDescriptor) {
        this(pDescriptor.resolver);
        this.values.putAll(pDescriptor.values);
    }

    public static void setOpenToken(String pToken) {
        openToken = pToken;
    }

    public static void setCloseToken(String pToken) {
        closeToken = pToken;
    }

    protected void parse(InputStream pInput) throws IOException, ParseException {
        BufferedReader br = new BufferedReader(new InputStreamReader(pInput));
        StringBuilder buffer = new StringBuilder();
        String key = null;
        int linenr = 0;
        while (true) {
            String line;
            if ((line = br.readLine()) == null) {
                if (buffer.length() <= 0) break;
                this.set(key, buffer.toString());
                buffer = null;
                break;
            }
            ++linenr;
            if (line.length() == 0) {
                throw new ParseException("Empty line", linenr);
            }
            char first = line.charAt(0);
            if (Character.isLetter(first)) {
                int i;
                if (buffer.length() > 0) {
                    this.set(key, buffer.toString());
                    buffer = new StringBuilder();
                }
                if ((i = line.indexOf(58)) < 0) {
                    throw new ParseException("Line misses ':' delimiter", linenr);
                }
                key = line.substring(0, i);
                buffer.append(line.substring(i + 1).trim());
                continue;
            }
            buffer.append('\n').append(line.substring(1));
        }
        br.close();
    }

    public void set(String pKey, String pValue) {
        String value = Utils.replaceVariables(this.resolver, pValue, openToken, closeToken);
        if ("".equals(value)) {
            value = null;
        }
        this.values.put(pKey, value);
    }

    public String get(String key) {
        return this.values.get(key);
    }

    public abstract String[] getMandatoryKeys();

    public boolean isValid() {
        return this.invalidKeys().size() == 0;
    }

    public Set<String> invalidKeys() {
        HashSet<String> invalid = new HashSet<String>();
        for (String aMk : this.getMandatoryKeys()) {
            if (this.get(aMk) != null) continue;
            invalid.add(aMk);
        }
        return invalid;
    }

    public String toString(String[] keys) {
        StringBuilder s = new StringBuilder();
        for (String key : keys) {
            String value = this.values.get(key);
            if (value == null) continue;
            s.append(key).append(":");
            try {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(value));
                while ((line = reader.readLine()) != null) {
                    if (line.length() != 0 && !Character.isWhitespace(line.charAt(0))) {
                        s.append(' ');
                    }
                    s.append(line).append('\n');
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return s.toString();
    }
}

