/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPDigestCalculator;

class SHA1PGPDigestCalculator
implements PGPDigestCalculator {
    private MessageDigest digest;

    SHA1PGPDigestCalculator() {
        try {
            this.digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("cannot find SHA-1: " + noSuchAlgorithmException.getMessage());
        }
    }

    public int getAlgorithm() {
        return 2;
    }

    public OutputStream getOutputStream() {
        return new DigestOutputStream(this.digest);
    }

    public byte[] getDigest() {
        return this.digest.digest();
    }

    public void reset() {
        this.digest.reset();
    }

    private class DigestOutputStream
    extends OutputStream {
        private MessageDigest dig;

        DigestOutputStream(MessageDigest messageDigest) {
            this.dig = messageDigest;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.dig.update(byArray);
        }

        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }

        byte[] getDigest() {
            return this.dig.digest();
        }
    }
}

