/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.filters.FixCrLfFilter;
import org.apache.tools.ant.util.ReaderInputStream;
import org.vafer.jdeb.utils.VariableResolver;

public final class Utils {
    public static int copy(InputStream pInput, OutputStream pOutput) throws IOException {
        int n;
        byte[] buffer = new byte[2048];
        int count = 0;
        while (-1 != (n = pInput.read(buffer))) {
            pOutput.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Integer.toHexString(b >> 4 & 0xF));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString();
    }

    public static String stripPath(int p, String s) {
        if (p <= 0) {
            return s;
        }
        int x = 0;
        for (int i = 0; i < p; ++i) {
            if ((x = s.indexOf(47, x + 1)) >= 0) continue;
            return s;
        }
        return s.substring(x + 1);
    }

    public static String stripLeadingSlash(String s) {
        if (s == null) {
            return s;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.charAt(0) == '/' || s.charAt(0) == '\\') {
            return s.substring(1);
        }
        return s;
    }

    public static String replaceVariables(VariableResolver pResolver, String pExpression, String pOpen, String pClose) {
        char[] open = pOpen.toCharArray();
        char[] close = pClose.toCharArray();
        StringBuilder out = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        char[] last = null;
        int wo = 0;
        int wc = 0;
        int level = 0;
        for (char c : pExpression.toCharArray()) {
            if (c == open[wo]) {
                if (open.length != ++wo) continue;
                if (last == open) {
                    out.append(open);
                }
                ++level;
                out.append((CharSequence)sb);
                sb = new StringBuilder();
                wo = 0;
                last = open;
                continue;
            }
            if (c == close[wc]) {
                if (close.length != ++wc) continue;
                if (last == open) {
                    String variable = pResolver.get(sb.toString());
                    if (variable != null) {
                        out.append(variable);
                    } else {
                        out.append(open);
                        out.append((CharSequence)sb);
                        out.append(close);
                    }
                } else {
                    out.append((CharSequence)sb);
                    out.append(close);
                }
                sb = new StringBuilder();
                --level;
                wc = 0;
                last = close;
                continue;
            }
            if (wo > 0) {
                sb.append(open, 0, wo);
            }
            if (wc > 0) {
                sb.append(close, 0, wc);
            }
            sb.append(c);
            wc = 0;
            wo = 0;
        }
        if (level > 0) {
            out.append(open);
        }
        out.append((CharSequence)sb);
        return out.toString();
    }

    public static byte[] toUnixLineEndings(InputStream input) throws IOException {
        String encoding = "ISO-8859-1";
        FixCrLfFilter filter = new FixCrLfFilter((Reader)new InputStreamReader(input, encoding));
        filter.setEol(FixCrLfFilter.CrLf.newInstance((String)"unix"));
        ByteArrayOutputStream filteredFile = new ByteArrayOutputStream();
        Utils.copy((InputStream)new ReaderInputStream((Reader)filter, encoding), filteredFile);
        return filteredFile.toByteArray();
    }

    public static String convertToDebianVersion(String version, boolean apply, String envName, Date timestamp) {
        Pattern pattern2;
        Pattern pattern1 = Pattern.compile("(.*)[\\-\\+]SNAPSHOT");
        Matcher matcher = pattern1.matcher(version);
        if (matcher.matches()) {
            version = matcher.group(1) + "~";
            if (apply) {
                String envValue = System.getenv(envName);
                String snapshot = envValue != null && envValue.length() > 0 ? envValue : new SimpleDateFormat("yyyyMMddHHmmss").format(timestamp);
                version = version + snapshot;
            } else {
                version = version + "SNAPSHOT";
            }
        }
        if ((matcher = (pattern2 = Pattern.compile("(.*?)([\\.\\-_]?)(alpha|beta|rc)(.*)", 2)).matcher(version)).matches()) {
            version = matcher.group(1) + "~" + matcher.group(3) + matcher.group(4);
        }
        version = version.replace('-', '+');
        return version;
    }

    public static String movePath(String file, String target) {
        String name = new File(file).getName();
        return target.endsWith("/") ? target + name : target + '/' + name;
    }

    public static String lookupIfEmpty(String value, Map<String, String> props, String key) {
        return value != null ? value : props.get(key);
    }

    public static Collection<String> getKnownPGPSecureRingLocations() {
        String home;
        boolean runOnWindows;
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        String os = System.getProperty("os.name");
        boolean bl = runOnWindows = os == null || os.toLowerCase().contains("win");
        if (runOnWindows) {
            String windir;
            String windowsLocal;
            String windowsRoaming = System.getenv("APPDATA");
            if (windowsRoaming != null) {
                locations.add(Utils.joinPaths(windowsRoaming, "gnupg", "secring.gpg"));
            }
            if ((windowsLocal = System.getenv("LOCALAPPDATA")) != null) {
                locations.add(Utils.joinPaths(windowsLocal, "gnupg", "secring.gpg"));
            }
            if ((windir = System.getProperty("WINDIR")) != null) {
                locations.add(Utils.joinPaths(windir, "Application Data", "gnupg", "secring.gpg"));
            }
        }
        if ((home = System.getProperty("user.home")) != null && runOnWindows) {
            locations.add(Utils.joinPaths(home, "AppData", "Roaming", "gnupg", "secring.gpg"));
            locations.add(Utils.joinPaths(home, "AppData", "Local", "gnupg", "secring.gpg"));
            locations.add(Utils.joinPaths(home, "Application Data", "gnupg", "secring.gpg"));
            locations.add(Utils.joinPaths(home, "Local Settings", "Application Data", "gnupg", "secring.gpg"));
        }
        if (home != null) {
            locations.add(Utils.joinPaths(home, ".gnupg", "secring.gpg"));
        }
        return locations;
    }

    public static File guessKeyRingFile() throws FileNotFoundException {
        Collection<String> possibleLocations = Utils.getKnownPGPSecureRingLocations();
        for (String location : possibleLocations) {
            File candidate = new File(location);
            if (!candidate.exists()) continue;
            return candidate;
        }
        StringBuilder message = new StringBuilder("Could not locate secure keyring, locations tried: ");
        Iterator<String> it = possibleLocations.iterator();
        while (it.hasNext()) {
            message.append(it.next());
            if (!it.hasNext()) continue;
            message.append(", ");
        }
        throw new FileNotFoundException(message.toString());
    }

    public static String joinPaths(String ... elements) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String element : elements) {
            if (element == null) continue;
            if (!first) {
                builder.append(File.separatorChar);
            }
            builder.append(element);
            first = false;
        }
        return builder.toString();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

