/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.changes;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.vafer.jdeb.changes.ChangeSet;
import org.vafer.jdeb.changes.ChangesProvider;
import org.vafer.jdeb.debian.BinaryPackageControlFile;

public final class TextfileChangesProvider
implements ChangesProvider {
    private final ChangeSet[] changeSets;
    private final DateFormat fmt;

    public TextfileChangesProvider(InputStream pInput, BinaryPackageControlFile packageControlFile) throws IOException, ParseException {
        this(pInput, packageControlFile, null);
    }

    public TextfileChangesProvider(InputStream pInput, BinaryPackageControlFile packageControlFile, Long outputTimestampMs) throws IOException, ParseException {
        ChangeSet changeSet;
        String[] changes;
        ArrayList<ChangeSet> changeSetColl;
        ArrayList<String> changesColl;
        String changedBy;
        String urgency;
        String distribution;
        Date date;
        String version;
        String packageName;
        BufferedReader reader;
        block14: {
            String line;
            this.fmt = new SimpleDateFormat("HH:mm dd.MM.yyyy");
            if (outputTimestampMs != null) {
                this.fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            reader = new BufferedReader(new InputStreamReader(pInput));
            packageName = packageControlFile.get("Package");
            version = packageControlFile.get("Version");
            date = outputTimestampMs == null ? new Date() : new Date(outputTimestampMs);
            distribution = packageControlFile.get("Distribution");
            urgency = packageControlFile.get("Urgency");
            changedBy = packageControlFile.get("Maintainer");
            changesColl = new ArrayList<String>();
            changeSetColl = new ArrayList<ChangeSet>();
            block0: while (true) {
                if ((line = reader.readLine()) == null) break block14;
                if (line.startsWith("release ")) {
                    String[] tokens;
                    if (changesColl.size() > 0) {
                        changes = changesColl.toArray(new String[changesColl.size()]);
                        changeSet = new ChangeSet(packageName, version, date, distribution, urgency, changedBy, changes);
                        changeSetColl.add(changeSet);
                        changesColl.clear();
                    }
                    String[] stringArray = tokens = line.substring("release ".length()).split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block0;
                        String token = stringArray[n2];
                        String[] lr = token.trim().split("=");
                        String key = lr[0];
                        String value = lr[1];
                        if ("urgency".equals(key)) {
                            urgency = value;
                        } else if ("by".equals(key)) {
                            changedBy = value;
                        } else if ("date".equals(key)) {
                            date = this.fmt.parse(value);
                        } else if ("version".equals(key)) {
                            version = value;
                        } else if ("distribution".equals(key)) {
                            distribution = value;
                        }
                        ++n2;
                    }
                }
                if (!line.startsWith(" * ")) break;
                changesColl.add(line.substring(" * ".length()));
            }
            throw new ParseException("Unknown line syntax [" + line + "]", 0);
        }
        changes = changesColl.toArray(new String[changesColl.size()]);
        changeSet = new ChangeSet(packageName, version, date, distribution, urgency, changedBy, changes);
        changeSetColl.add(changeSet);
        reader.close();
        this.changeSets = changeSetColl.toArray(new ChangeSet[changeSetColl.size()]);
    }

    public void save(OutputStream pOutput) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(pOutput));
        for (ChangeSet changeSet : this.changeSets) {
            writer.write("release ");
            writer.write("date=" + this.fmt.format(changeSet.getDate()) + ",");
            writer.write("version=" + changeSet.getVersion() + ",");
            writer.write("urgency=" + changeSet.getUrgency() + ",");
            writer.write("by=" + changeSet.getChangedBy() + ",");
            writer.write("distribution=" + changeSet.getDistribution());
            writer.write("\n");
            for (String change : changeSet.getChanges()) {
                writer.write(" * ");
                writer.write(change);
                writer.write("\n");
            }
        }
        writer.close();
    }

    @Override
    public ChangeSet[] getChangesSets() {
        return this.changeSets;
    }
}

