/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.pqc.jcajce.provider.lms;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import org.vafer.jdeb.shaded.bc.asn1.x509.SubjectPublicKeyInfo;
import org.vafer.jdeb.shaded.bc.crypto.CipherParameters;
import org.vafer.jdeb.shaded.bc.pqc.crypto.lms.HSSPublicKeyParameters;
import org.vafer.jdeb.shaded.bc.pqc.crypto.lms.LMSKeyParameters;
import org.vafer.jdeb.shaded.bc.pqc.crypto.lms.LMSPublicKeyParameters;
import org.vafer.jdeb.shaded.bc.pqc.crypto.util.PublicKeyFactory;
import org.vafer.jdeb.shaded.bc.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.vafer.jdeb.shaded.bc.pqc.jcajce.interfaces.LMSKey;
import org.vafer.jdeb.shaded.bc.util.Arrays;

public class BCLMSPublicKey
implements PublicKey,
LMSKey {
    private static final long serialVersionUID = -5617456225328969766L;
    private transient LMSKeyParameters keyParams;

    public BCLMSPublicKey(LMSKeyParameters lMSKeyParameters) {
        this.keyParams = lMSKeyParameters;
    }

    public BCLMSPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.keyParams = (LMSKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public final String getAlgorithm() {
        return "LMS";
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.keyParams);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCLMSPublicKey) {
            BCLMSPublicKey bCLMSPublicKey = (BCLMSPublicKey)object;
            try {
                return Arrays.areEqual(this.keyParams.getEncoded(), bCLMSPublicKey.keyParams.getEncoded());
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return Arrays.hashCode(this.keyParams.getEncoded());
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public int getLevels() {
        if (this.keyParams instanceof LMSPublicKeyParameters) {
            return 1;
        }
        return ((HSSPublicKeyParameters)this.keyParams).getL();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

