/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg;

import org.vafer.jdeb.shaded.bc.bcpg.AEADAlgorithmTags;
import org.vafer.jdeb.shaded.bc.bcpg.SymmetricKeyUtils;

public class AEADUtils
implements AEADAlgorithmTags {
    private AEADUtils() {
    }

    public static int getIVLength(int n) {
        switch (n) {
            case 1: {
                return 16;
            }
            case 2: {
                return 15;
            }
            case 3: {
                return 12;
            }
        }
        throw new IllegalArgumentException("Invalid AEAD algorithm tag: " + n);
    }

    public static int getAuthTagLength(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return 16;
            }
        }
        throw new IllegalArgumentException("Invalid AEAD algorithm tag: " + n);
    }

    public static byte[][] splitMessageKeyAndIv(byte[] byArray, int n, int n2) {
        int n3 = SymmetricKeyUtils.getKeyLengthInOctets(n);
        int n4 = AEADUtils.getIVLength(n2);
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        System.arraycopy(byArray, byArray2.length, byArray3, 0, n4 - 8);
        return new byte[][]{byArray2, byArray3};
    }
}

