/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg;

import java.io.IOException;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGInputStream;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGObject;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGOutputStream;
import org.vafer.jdeb.shaded.bc.util.Arrays;

public abstract class OctetArrayBCPGKey
extends BCPGObject
implements BCPGKey {
    private final byte[] key;

    OctetArrayBCPGKey(int n, BCPGInputStream bCPGInputStream) throws IOException {
        this.key = new byte[n];
        bCPGInputStream.readFully(this.key);
    }

    OctetArrayBCPGKey(int n, byte[] byArray) {
        if (byArray.length != n) {
            throw new IllegalArgumentException("unexpected key encoding length: expected " + n + " bytes, got " + byArray.length);
        }
        this.key = new byte[n];
        System.arraycopy(byArray, 0, this.key, 0, n);
    }

    @Override
    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.write(this.key);
    }

    public byte[] getKey() {
        return Arrays.clone(this.key);
    }
}

