/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGInputStream;
import org.vafer.jdeb.shaded.bc.bcpg.ContainedPacket;
import org.vafer.jdeb.shaded.bc.bcpg.KeyIdentifier;
import org.vafer.jdeb.shaded.bc.bcpg.Packet;
import org.vafer.jdeb.shaded.bc.bcpg.PacketFormat;
import org.vafer.jdeb.shaded.bc.bcpg.SignaturePacket;
import org.vafer.jdeb.shaded.bc.bcpg.TrustPacket;
import org.vafer.jdeb.shaded.bc.bcpg.UnsupportedPacketVersionException;
import org.vafer.jdeb.shaded.bc.bcpg.UserAttributePacket;
import org.vafer.jdeb.shaded.bc.bcpg.UserDataPacket;
import org.vafer.jdeb.shaded.bc.bcpg.UserIDPacket;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPublicKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignature;
import org.vafer.jdeb.shaded.bc.openpgp.PGPUserAttributeSubpacketVector;

public abstract class PGPKeyRing {
    private static final Logger LOG = Logger.getLogger(PGPKeyRing.class.getName());

    PGPKeyRing() {
    }

    static TrustPacket readOptionalTrustPacket(BCPGInputStream bCPGInputStream) throws IOException {
        int n = bCPGInputStream.skipMarkerAndPaddingPackets();
        return n == 12 ? (TrustPacket)bCPGInputStream.readPacket() : null;
    }

    static List<PGPSignature> readSignaturesAndTrust(BCPGInputStream bCPGInputStream) throws IOException {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        while (bCPGInputStream.skipMarkerAndPaddingPackets() == 2) {
            try {
                SignaturePacket signaturePacket = (SignaturePacket)bCPGInputStream.readPacket();
                TrustPacket trustPacket = PGPKeyRing.readOptionalTrustPacket(bCPGInputStream);
                arrayList.add(new PGPSignature(signaturePacket, trustPacket));
            }
            catch (UnsupportedPacketVersionException unsupportedPacketVersionException) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("skipping unknown signature: " + unsupportedPacketVersionException.getMessage());
            }
        }
        return arrayList;
    }

    static void readUserIDs(BCPGInputStream bCPGInputStream, List<UserDataPacket> list, List<TrustPacket> list2, List<List<PGPSignature>> list3) throws IOException {
        while (PGPKeyRing.isUserTag(bCPGInputStream.skipMarkerAndPaddingPackets())) {
            ContainedPacket containedPacket;
            Packet packet = bCPGInputStream.readPacket();
            if (packet instanceof UserIDPacket) {
                containedPacket = (UserIDPacket)packet;
                list.add((UserDataPacket)((Object)containedPacket));
            } else {
                containedPacket = (UserAttributePacket)packet;
                list.add(new PGPUserAttributeSubpacketVector(((UserAttributePacket)containedPacket).getSubpackets()));
            }
            list2.add(PGPKeyRing.readOptionalTrustPacket(bCPGInputStream));
            list3.add(PGPKeyRing.readSignaturesAndTrust(bCPGInputStream));
        }
    }

    public abstract PGPPublicKey getPublicKey();

    public abstract Iterator<PGPPublicKey> getPublicKeys();

    public abstract PGPPublicKey getPublicKey(long var1);

    public abstract PGPPublicKey getPublicKey(byte[] var1);

    public abstract PGPPublicKey getPublicKey(KeyIdentifier var1);

    public abstract Iterator<PGPPublicKey> getPublicKeys(KeyIdentifier var1);

    public abstract Iterator<PGPPublicKey> getKeysWithSignaturesBy(long var1);

    public abstract Iterator<PGPPublicKey> getKeysWithSignaturesBy(KeyIdentifier var1);

    public abstract int size();

    public abstract void encode(OutputStream var1) throws IOException;

    public abstract byte[] getEncoded() throws IOException;

    public abstract byte[] getEncoded(PacketFormat var1) throws IOException;

    private static boolean isUserTag(int n) {
        switch (n) {
            case 13: 
            case 17: {
                return true;
            }
        }
        return false;
    }
}

