/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp;

import org.vafer.jdeb.shaded.bc.bcpg.BCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.KeyIdentifier;
import org.vafer.jdeb.shaded.bc.bcpg.PublicKeyPacket;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.operator.KeyFingerPrintCalculator;

public class PGPPrivateKey {
    private long keyID;
    private PublicKeyPacket publicKeyPacket;
    private BCPGKey privateKeyDataPacket;

    public PGPPrivateKey(long l, PublicKeyPacket publicKeyPacket, BCPGKey bCPGKey) {
        this.keyID = l;
        this.publicKeyPacket = publicKeyPacket;
        this.privateKeyDataPacket = bCPGKey;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public KeyIdentifier getKeyIdentifier(KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        byte[] byArray = keyFingerPrintCalculator.calculateFingerprint(this.publicKeyPacket);
        return new KeyIdentifier(byArray, PublicKeyPacket.getKeyID(this.publicKeyPacket, byArray));
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.publicKeyPacket;
    }

    public BCPGKey getPrivateKeyDataPacket() {
        return this.privateKeyDataPacket;
    }
}

