/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

public class FilteredFile {
    public static final String DEFAULT_OPEN_TOKEN = "[[";
    public static final String DEFAULT_CLOSE_TOKEN = "]]";
    private String openToken;
    private String closeToken;
    private List<String> lines = new ArrayList<String>();

    @Deprecated
    public FilteredFile(InputStream in, VariableResolver resolver) throws IOException {
        this(in, resolver, Charset.defaultCharset());
    }

    public FilteredFile(InputStream in, VariableResolver resolver, Charset encoding) throws IOException {
        this(in, resolver, encoding, DEFAULT_OPEN_TOKEN, DEFAULT_CLOSE_TOKEN);
    }

    public FilteredFile(InputStream in, VariableResolver resolver, Charset encoding, String openToken, String closeToken) throws IOException {
        this.openToken = openToken;
        this.closeToken = closeToken;
        this.parse(in, resolver, encoding);
    }

    @Deprecated
    public void setOpenToken(String token) {
        this.openToken = token;
    }

    @Deprecated
    public void setCloseToken(String token) {
        this.closeToken = token;
    }

    private void parse(InputStream in, VariableResolver resolver, Charset encoding) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (resolver != null) {
                    this.lines.add(Utils.replaceVariables(resolver, line, this.openToken, this.closeToken));
                    continue;
                }
                this.lines.add(line);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String line : this.lines) {
            builder.append(line).append('\n');
        }
        return builder.toString();
    }
}

