/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.types.FileSet;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarArchiveEntry;
import org.vafer.jdeb.utils.SymlinkUtils;

public final class DataProducerFileSet
implements DataProducer {
    private final FileSet fileset;

    public DataProducerFileSet(FileSet fileset) {
        this.fileset = fileset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produce(DataConsumer pReceiver) throws IOException {
        String name;
        String user = "root";
        int uid = 0;
        String group = "root";
        int gid = 0;
        int filemode = 33188;
        int dirmode = 16877;
        String prefix = "";
        if (this.fileset instanceof Tar.TarFileSet) {
            Tar.TarFileSet tarfileset = (Tar.TarFileSet)this.fileset;
            user = tarfileset.getUserName();
            uid = tarfileset.getUid();
            group = tarfileset.getGroup();
            gid = tarfileset.getGid();
            filemode = tarfileset.getMode();
            dirmode = tarfileset.getDirMode(tarfileset.getProject());
            prefix = tarfileset.getPrefix(tarfileset.getProject());
        }
        DirectoryScanner scanner = this.fileset.getDirectoryScanner(this.fileset.getProject());
        scanner.scan();
        File basedir = scanner.getBasedir();
        for (String directory : scanner.getIncludedDirectories()) {
            name = directory.replace('\\', '/');
            TarArchiveEntry entry = new TarArchiveEntry(prefix + "/" + name);
            entry.setUserName(user);
            entry.setUserId(uid);
            entry.setGroupName(group);
            entry.setGroupId(gid);
            entry.setMode(dirmode);
            pReceiver.onEachDir(entry);
        }
        for (String filename : scanner.getIncludedFiles()) {
            name = filename.replace('\\', '/');
            File file = new File(basedir, name);
            FileInputStream inputStream = new FileInputStream(file);
            try {
                TarArchiveEntry e;
                String entryName = prefix + "/" + name;
                File entryPath = new File(entryName);
                boolean symbolicLink = SymlinkUtils.isSymbolicLink(entryPath);
                if (symbolicLink) {
                    e = new TarArchiveEntry(entryName, 50);
                    e.setLinkName(SymlinkUtils.readSymbolicLink(entryPath));
                } else {
                    e = new TarArchiveEntry(entryName, true);
                }
                e.setUserId(uid);
                e.setGroupId(gid);
                e.setUserName(user);
                e.setGroupName(group);
                e.setMode(filemode);
                e.setSize(file.length());
                pReceiver.onEachFile(inputStream, e);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
    }
}

