/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.crypto.util;

import java.io.IOException;
import org.vafer.jdeb.shaded.bc.asn1.ASN1Integer;
import org.vafer.jdeb.shaded.bc.asn1.ASN1Object;
import org.vafer.jdeb.shaded.bc.asn1.ASN1OctetString;
import org.vafer.jdeb.shaded.bc.asn1.DERNull;
import org.vafer.jdeb.shaded.bc.asn1.pkcs.PKCSObjectIdentifiers;
import org.vafer.jdeb.shaded.bc.asn1.pkcs.RSAPublicKey;
import org.vafer.jdeb.shaded.bc.asn1.x509.AlgorithmIdentifier;
import org.vafer.jdeb.shaded.bc.asn1.x509.DSAParameter;
import org.vafer.jdeb.shaded.bc.asn1.x509.SubjectPublicKeyInfo;
import org.vafer.jdeb.shaded.bc.asn1.x9.X962Parameters;
import org.vafer.jdeb.shaded.bc.asn1.x9.X9ECParameters;
import org.vafer.jdeb.shaded.bc.asn1.x9.X9ECPoint;
import org.vafer.jdeb.shaded.bc.asn1.x9.X9ObjectIdentifiers;
import org.vafer.jdeb.shaded.bc.crypto.params.AsymmetricKeyParameter;
import org.vafer.jdeb.shaded.bc.crypto.params.DSAParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.DSAPublicKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.ECDomainParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.ECNamedDomainParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.ECPublicKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.RSAKeyParameters;

public class SubjectPublicKeyInfoFactory {
    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPublicKey(rSAKeyParameters.getModulus(), rSAKeyParameters.getExponent()));
        }
        if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)asymmetricKeyParameter;
            DSAParameter dSAParameter = null;
            DSAParameters dSAParameters = dSAPublicKeyParameters.getParameters();
            if (dSAParameters != null) {
                dSAParameter = new DSAParameter(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG());
            }
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, dSAParameter), new ASN1Integer(dSAPublicKeyParameters.getY()));
        }
        if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
            ASN1Object aSN1Object;
            X962Parameters x962Parameters;
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricKeyParameter;
            ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
            if (eCDomainParameters == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else if (eCDomainParameters instanceof ECNamedDomainParameters) {
                x962Parameters = new X962Parameters(((ECNamedDomainParameters)eCDomainParameters).getName());
            } else {
                aSN1Object = new X9ECParameters(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
                x962Parameters = new X962Parameters((X9ECParameters)aSN1Object);
            }
            aSN1Object = (ASN1OctetString)new X9ECPoint(eCPublicKeyParameters.getQ()).toASN1Primitive();
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), ((ASN1OctetString)aSN1Object).getOctets());
        }
        throw new IOException("key parameters not recognised.");
    }
}

