/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.math.ec.custom.sec;

import java.math.BigInteger;
import java.util.Random;
import org.vafer.jdeb.shaded.bc.math.ec.ECConstants;
import org.vafer.jdeb.shaded.bc.math.ec.ECCurve;
import org.vafer.jdeb.shaded.bc.math.ec.ECFieldElement;
import org.vafer.jdeb.shaded.bc.math.ec.ECPoint;
import org.vafer.jdeb.shaded.bc.math.ec.custom.sec.SecT113FieldElement;
import org.vafer.jdeb.shaded.bc.math.ec.custom.sec.SecT113R2Point;
import org.vafer.jdeb.shaded.bc.util.encoders.Hex;

public class SecT113R2Curve
extends ECCurve.AbstractF2m {
    private static final int SecT113R2_DEFAULT_COORDS = 6;
    protected SecT113R2Point infinity = new SecT113R2Point(this, null, null);

    public SecT113R2Curve() {
        super(113, 9, 0, 0);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("00689918DBEC7E5A0DD6DFC0AA55C7")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("0095E9A9EC9B297BD4BF36E059184F")));
        this.order = new BigInteger(1, Hex.decode("010000000000000108789B2496AF93"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT113R2Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 113;
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT113FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
        return new SecT113R2Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
        return new SecT113R2Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    protected ECPoint decompressPoint(int n, BigInteger bigInteger) {
        ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
        ECFieldElement eCFieldElement2 = null;
        if (eCFieldElement.isZero()) {
            eCFieldElement2 = this.b.sqrt();
        } else {
            ECFieldElement eCFieldElement3 = eCFieldElement.square().invert().multiply(this.b).add(this.a).add(eCFieldElement);
            ECFieldElement eCFieldElement4 = this.solveQuadraticEquation(eCFieldElement3);
            if (eCFieldElement4 != null) {
                if (eCFieldElement4.testBitZero() != (n == 1)) {
                    eCFieldElement4 = eCFieldElement4.addOne();
                }
                switch (this.getCoordinateSystem()) {
                    case 5: 
                    case 6: {
                        eCFieldElement2 = eCFieldElement4.add(eCFieldElement);
                        break;
                    }
                    default: {
                        eCFieldElement2 = eCFieldElement4.multiply(eCFieldElement);
                    }
                }
            }
        }
        if (eCFieldElement2 == null) {
            throw new IllegalArgumentException("Invalid point compression");
        }
        return this.createRawPoint(eCFieldElement, eCFieldElement2, true);
    }

    private ECFieldElement solveQuadraticEquation(ECFieldElement eCFieldElement) {
        if (eCFieldElement.isZero()) {
            return eCFieldElement;
        }
        ECFieldElement eCFieldElement2 = this.fromBigInteger(ECConstants.ZERO);
        ECFieldElement eCFieldElement3 = null;
        ECFieldElement eCFieldElement4 = null;
        Random random = new Random();
        do {
            ECFieldElement eCFieldElement5 = this.fromBigInteger(new BigInteger(113, random));
            eCFieldElement3 = eCFieldElement2;
            ECFieldElement eCFieldElement6 = eCFieldElement;
            for (int i = 1; i < 113; ++i) {
                ECFieldElement eCFieldElement7 = eCFieldElement6.square();
                eCFieldElement3 = eCFieldElement3.square().add(eCFieldElement7.multiply(eCFieldElement5));
                eCFieldElement6 = eCFieldElement7.add(eCFieldElement);
            }
            if (eCFieldElement6.isZero()) continue;
            return null;
        } while ((eCFieldElement4 = eCFieldElement3.square().add(eCFieldElement3)).isZero());
        return eCFieldElement3;
    }

    public int getM() {
        return 113;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 9;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }
}

