/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.xz.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.vafer.jdeb.shaded.xz.xz.BlockInputStream;
import org.vafer.jdeb.shaded.xz.xz.CorruptedInputException;
import org.vafer.jdeb.shaded.xz.xz.IndexIndicatorException;
import org.vafer.jdeb.shaded.xz.xz.XZIOException;
import org.vafer.jdeb.shaded.xz.xz.check.Check;
import org.vafer.jdeb.shaded.xz.xz.common.DecoderUtil;
import org.vafer.jdeb.shaded.xz.xz.common.StreamFlags;
import org.vafer.jdeb.shaded.xz.xz.index.IndexHash;

public class SingleXZInputStream
extends InputStream {
    private InputStream in;
    private int memoryLimit;
    private StreamFlags streamHeaderFlags;
    private Check check;
    private BlockInputStream blockDecoder = null;
    private final IndexHash indexHash = new IndexHash();
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    public SingleXZInputStream(InputStream inputStream) throws IOException {
        this.initialize(inputStream, -1);
    }

    public SingleXZInputStream(InputStream inputStream, int n) throws IOException {
        this.initialize(inputStream, n);
    }

    SingleXZInputStream(InputStream inputStream, int n, byte[] byArray) throws IOException {
        this.initialize(inputStream, n, byArray);
    }

    private void initialize(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[12];
        new DataInputStream(inputStream).readFully(byArray);
        this.initialize(inputStream, n, byArray);
    }

    private void initialize(InputStream inputStream, int n, byte[] byArray) throws IOException {
        this.in = inputStream;
        this.memoryLimit = n;
        this.streamHeaderFlags = DecoderUtil.decodeStreamHeader(byArray);
        this.check = Check.getInstance(this.streamHeaderFlags.checkType);
    }

    public int getCheckType() {
        return this.streamHeaderFlags.checkType;
    }

    public String getCheckName() {
        return this.check.getName();
    }

    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block12: {
            if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.endReached) {
                return -1;
            }
            n3 = 0;
            try {
                while (n2 > 0) {
                    int n4;
                    if (this.blockDecoder == null) {
                        try {
                            this.blockDecoder = new BlockInputStream(this.in, this.check, this.memoryLimit, -1L, -1L);
                        }
                        catch (IndexIndicatorException indexIndicatorException) {
                            this.indexHash.validate(this.in);
                            this.validateStreamFooter();
                            this.endReached = true;
                            return n3 > 0 ? n3 : -1;
                        }
                    }
                    if ((n4 = this.blockDecoder.read(byArray, n, n2)) > 0) {
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        continue;
                    }
                    if (n4 != -1) continue;
                    this.indexHash.add(this.blockDecoder.getUnpaddedSize(), this.blockDecoder.getUncompressedSize());
                    this.blockDecoder = null;
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
                if (n3 != 0) break block12;
                throw iOException;
            }
        }
        return n3;
    }

    private void validateStreamFooter() throws IOException {
        byte[] byArray = new byte[12];
        new DataInputStream(this.in).readFully(byArray);
        StreamFlags streamFlags = DecoderUtil.decodeStreamFooter(byArray);
        if (!DecoderUtil.areStreamFlagsEqual(this.streamHeaderFlags, streamFlags) || this.indexHash.getIndexSize() != streamFlags.backwardSize) {
            throw new CorruptedInputException("XZ Stream Footer does not match Stream Header");
        }
    }

    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.blockDecoder == null ? 0 : this.blockDecoder.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }
}

