/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.debian;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.vafer.jdeb.changes.ChangeSet;
import org.vafer.jdeb.debian.BinaryPackageControlFile;
import org.vafer.jdeb.debian.ControlField;
import org.vafer.jdeb.debian.ControlFile;
import org.vafer.jdeb.utils.Utils;

public final class ChangesFile
extends ControlFile {
    private static final ControlField[] FIELDS = new ControlField[]{new ControlField("Format", true), new ControlField("Date", true), new ControlField("Source", true), new ControlField("Binary", true), new ControlField("Architecture", true), new ControlField("Version", true), new ControlField("Distribution", true), new ControlField("Urgency", true), new ControlField("Maintainer", true), new ControlField("Changed-By"), new ControlField("Description", true, ControlField.Type.MULTILINE, true), new ControlField("Changes", true, ControlField.Type.MULTILINE, true), new ControlField("Closes"), new ControlField("Checksums-Sha1", true, ControlField.Type.MULTILINE, true), new ControlField("Checksums-Sha256", true, ControlField.Type.MULTILINE, true), new ControlField("Files", true, ControlField.Type.MULTILINE, true)};

    public ChangesFile() {
        this.set("Format", "1.8");
        this.set("Urgency", "low");
        this.set("Distribution", "stable");
    }

    public void initialize(BinaryPackageControlFile packageControlFile) {
        this.set("Binary", packageControlFile.get("Package"));
        this.set("Source", Utils.defaultString(packageControlFile.get("Source"), packageControlFile.get("Package")));
        this.set("Architecture", packageControlFile.get("Architecture"));
        this.set("Version", packageControlFile.get("Version"));
        this.set("Maintainer", packageControlFile.get("Maintainer"));
        this.set("Changed-By", packageControlFile.get("Maintainer"));
        this.set("Distribution", packageControlFile.get("Distribution"));
        for (Map.Entry<String, String> entry : packageControlFile.getUserDefinedFields().entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        StringBuilder description = new StringBuilder();
        description.append(packageControlFile.get("Package"));
        if (packageControlFile.get("Description") != null) {
            description.append(" - ");
            description.append(packageControlFile.getShortDescription());
        }
        this.set("Description", description.toString());
    }

    public void setChanges(ChangeSet[] changeSets) {
        StringBuilder sb = new StringBuilder();
        if (changeSets.length > 0) {
            ChangeSet mostRecentChangeSet = changeSets[0];
            this.set("Urgency", mostRecentChangeSet.getUrgency());
            this.set("Changed-By", mostRecentChangeSet.getChangedBy());
            for (ChangeSet changeSet : changeSets) {
                sb.append(changeSet.toString());
            }
        }
        this.set("Changes", sb.toString());
    }

    @Override
    protected ControlField[] getFields() {
        return FIELDS;
    }

    @Override
    protected char getUserDefinedFieldLetter() {
        return 'C';
    }

    public static String formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        return format.format(date);
    }
}

