/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.vafer.jdeb.ChangesFileBuilder;
import org.vafer.jdeb.Compression;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.ControlBuilder;
import org.vafer.jdeb.DataBuilder;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.PackagingException;
import org.vafer.jdeb.TarOptions;
import org.vafer.jdeb.changes.ChangeSet;
import org.vafer.jdeb.changes.ChangesProvider;
import org.vafer.jdeb.changes.TextfileChangesProvider;
import org.vafer.jdeb.debian.BinaryPackageControlFile;
import org.vafer.jdeb.debian.ChangesFile;
import org.vafer.jdeb.shaded.bc.crypto.digests.MD5Digest;
import org.vafer.jdeb.shaded.bc.jce.provider.BouncyCastleProvider;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignatureGenerator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.vafer.jdeb.shaded.bc.util.encoders.Hex;
import org.vafer.jdeb.shaded.commons.compress.archivers.ar.ArArchiveEntry;
import org.vafer.jdeb.shaded.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarArchiveEntry;
import org.vafer.jdeb.shaded.commons.io.FileUtils;
import org.vafer.jdeb.shaded.commons.io.FilenameUtils;
import org.vafer.jdeb.shaded.commons.io.IOUtils;
import org.vafer.jdeb.signing.PGPSigner;
import org.vafer.jdeb.utils.PGPSignatureOutputStream;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

public class DebMaker {
    private Console console;
    private File deb;
    private File control;
    private String packageName;
    private String section = "java";
    private String depends;
    private String description;
    private String homepage;
    private File keyring;
    private String key;
    private String passphrase;
    private File changesIn;
    private File changesOut;
    private File changesSave;
    private String compression = "gzip";
    private boolean signPackage;
    private boolean signChanges;
    private String signMethod;
    private String signRole;
    private String tarLongFileMode;
    private String tarBigNumberMode;
    private VariableResolver variableResolver;
    private String openReplaceToken;
    private String closeReplaceToken;
    private final Collection<DataProducer> dataProducers = new ArrayList<DataProducer>();
    private final Collection<DataProducer> conffilesProducers = new ArrayList<DataProducer>();
    private String digest = "SHA1";

    public DebMaker(Console console, Collection<DataProducer> dataProducers, Collection<DataProducer> conffileProducers) {
        this.console = console;
        if (dataProducers != null) {
            this.dataProducers.addAll(dataProducers);
        }
        if (conffileProducers != null) {
            this.conffilesProducers.addAll(conffileProducers);
        }
        Security.addProvider(new BouncyCastleProvider());
    }

    public void setDeb(File deb) {
        this.deb = deb;
    }

    public void setControl(File control) {
        this.control = control;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public void setDepends(String depends) {
        this.depends = depends;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public void setChangesIn(File changes) {
        this.changesIn = changes;
    }

    public void setChangesOut(File changes) {
        this.changesOut = changes;
    }

    public void setChangesSave(File changes) {
        this.changesSave = changes;
    }

    public void setSignPackage(boolean signPackage) {
        this.signPackage = signPackage;
    }

    public void setSignChanges(boolean signChanges) {
        this.signChanges = signChanges;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public void setSignRole(String signRole) {
        this.signRole = signRole;
    }

    public void setKeyring(File keyring) {
        this.keyring = keyring;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public void setResolver(VariableResolver variableResolver) {
        this.variableResolver = variableResolver;
    }

    private boolean isWritableFile(File file) {
        return !file.exists() || file.isFile() && file.canWrite();
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void setTarLongFileMode(String tarLongFileMode) {
        this.tarLongFileMode = tarLongFileMode;
    }

    public void setTarBigNumberMode(String tarBigNumberMode) {
        this.tarBigNumberMode = tarBigNumberMode;
    }

    public void validate() throws PackagingException {
        if (this.control == null || !this.control.isDirectory()) {
            throw new PackagingException("The 'control' attribute doesn't point to a directory. " + this.control);
        }
        if (this.changesIn != null) {
            if (!(!this.changesIn.exists() || this.changesIn.isFile() && this.changesIn.canRead())) {
                throw new PackagingException("The 'changesIn' setting needs to point to a readable file. " + this.changesIn + " was not found/readable.");
            }
            if (this.changesOut != null && !this.isWritableFile(this.changesOut)) {
                throw new PackagingException("Cannot write the output for 'changesOut' to " + this.changesOut);
            }
            if (this.changesSave != null && !this.isWritableFile(this.changesSave)) {
                throw new PackagingException("Cannot write the output for 'changesSave' to " + this.changesSave);
            }
        } else if (this.changesOut != null || this.changesSave != null) {
            throw new PackagingException("The 'changesOut' or 'changesSave' settings may only be used when there is a 'changesIn' specified.");
        }
        if (Compression.toEnum(this.compression) == null) {
            throw new PackagingException("The compression method '" + this.compression + "' is not supported (expected 'none', 'gzip', 'bzip2' or 'xz')");
        }
        if (this.deb == null) {
            throw new PackagingException("You need to specify where the deb file is supposed to be created.");
        }
        DebMaker.getDigestCode(this.digest);
    }

    static int getDigestCode(String digestName) throws PackagingException {
        if ("SHA1".equals(digestName)) {
            return 2;
        }
        if ("MD2".equals(digestName)) {
            return 5;
        }
        if ("MD5".equals(digestName)) {
            return 1;
        }
        if ("RIPEMD160".equals(digestName)) {
            return 3;
        }
        if ("SHA256".equals(digestName)) {
            return 8;
        }
        if ("SHA384".equals(digestName)) {
            return 9;
        }
        if ("SHA512".equals(digestName)) {
            return 10;
        }
        if ("SHA224".equals(digestName)) {
            return 11;
        }
        throw new PackagingException("unknown hash algorithm tag in digestName: " + digestName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeDeb() throws PackagingException {
        BinaryPackageControlFile packageControlFile;
        block10: {
            try {
                this.console.info("Creating debian package: " + this.deb);
                boolean doSign = this.signPackage;
                if (doSign) {
                    if (this.keyring == null || !this.keyring.exists()) {
                        doSign = false;
                        this.console.warn("Signing requested, but no keyring supplied");
                    }
                    if (this.key == null) {
                        doSign = false;
                        this.console.warn("Signing requested, but no key supplied");
                    }
                    if (this.passphrase == null) {
                        doSign = false;
                        this.console.warn("Signing requested, but no passphrase supplied");
                    }
                    FileInputStream keyRingInput = new FileInputStream(this.keyring);
                    PGPSigner signer = null;
                    try {
                        signer = new PGPSigner(new FileInputStream(this.keyring), this.key, this.passphrase, DebMaker.getDigestCode(this.digest));
                    }
                    finally {
                        keyRingInput.close();
                    }
                    PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(new BcPGPContentSignerBuilder(signer.getSecretKey().getPublicKey().getAlgorithm(), DebMaker.getDigestCode(this.digest)));
                    signatureGenerator.init(0, signer.getPrivateKey());
                    packageControlFile = this.createSignedDeb(Compression.toEnum(this.compression), signatureGenerator, signer);
                    break block10;
                }
                packageControlFile = this.createDeb(Compression.toEnum(this.compression));
            }
            catch (Exception e) {
                throw new PackagingException("Failed to create debian package " + this.deb, e);
            }
        }
        this.makeChangesFiles(packageControlFile);
    }

    private void makeChangesFiles(final BinaryPackageControlFile packageControlFile) throws PackagingException {
        ChangesProvider changesProvider;
        if (this.changesOut == null) {
            this.changesOut = new File(this.deb.getParentFile(), FilenameUtils.getBaseName(this.deb.getName()) + ".changes");
        }
        FileOutputStream out = null;
        try {
            this.console.info("Creating changes file: " + this.changesOut);
            out = new FileOutputStream(this.changesOut);
            changesProvider = this.changesIn != null && this.changesIn.exists() ? new TextfileChangesProvider(new FileInputStream(this.changesIn), packageControlFile) : new ChangesProvider(){

                @Override
                public ChangeSet[] getChangesSets() {
                    return new ChangeSet[]{new ChangeSet(packageControlFile.get("Package"), packageControlFile.get("Version"), new Date(), packageControlFile.get("Distribution"), packageControlFile.get("Urgency"), packageControlFile.get("Maintainer"), new String[0])};
                }
            };
            ChangesFileBuilder builder = new ChangesFileBuilder();
            ChangesFile changesFile = builder.createChanges(packageControlFile, this.deb, changesProvider);
            if ((this.signChanges || this.signPackage) && this.keyring != null && this.key != null && this.passphrase != null) {
                this.console.info("Signing the changes file with the key " + this.key);
                PGPSigner signer = new PGPSigner(new FileInputStream(this.keyring), this.key, this.passphrase, DebMaker.getDigestCode(this.digest));
                signer.clearSign(changesFile.toString(), (OutputStream)out);
            } else {
                out.write(changesFile.toString().getBytes("UTF-8"));
            }
            out.flush();
        }
        catch (Exception e) {
            try {
                throw new PackagingException("Failed to create the Debian changes file " + this.changesOut, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
        if (this.changesSave == null || !(changesProvider instanceof TextfileChangesProvider)) {
            return;
        }
        try {
            this.console.info("Saving changes to file: " + this.changesSave);
            ((TextfileChangesProvider)changesProvider).save(new FileOutputStream(this.changesSave));
        }
        catch (Exception e) {
            throw new PackagingException("Failed to save debian changes file " + this.changesSave, e);
        }
    }

    private List<String> populateConffiles(Collection<DataProducer> producers) {
        final ArrayList<String> result = new ArrayList<String>();
        if (producers == null || producers.isEmpty()) {
            return result;
        }
        DataConsumer receiver = new DataConsumer(){

            @Override
            public void onEachFile(InputStream input, TarArchiveEntry entry) {
                String tempConffileItem = entry.getName();
                if (tempConffileItem.startsWith(".")) {
                    tempConffileItem = tempConffileItem.substring(1);
                }
                DebMaker.this.console.info("Adding conffile: " + tempConffileItem);
                result.add(tempConffileItem);
            }

            @Override
            public void onEachLink(TarArchiveEntry entry) {
            }

            @Override
            public void onEachDir(TarArchiveEntry tarArchiveEntry) {
            }
        };
        try {
            for (DataProducer data : producers) {
                data.produce(receiver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public BinaryPackageControlFile createDeb(Compression compression) throws PackagingException {
        return this.createSignedDeb(compression, null, null);
    }

    public BinaryPackageControlFile createSignedDeb(Compression compression, PGPSignatureGenerator signatureGenerator, PGPSigner signer) throws PackagingException {
        File tempData = null;
        File tempControl = null;
        try {
            tempData = File.createTempFile("deb", "data");
            tempControl = File.createTempFile("deb", "control");
            this.console.debug("Building data");
            DataBuilder dataBuilder = new DataBuilder(this.console);
            StringBuilder md5s = new StringBuilder();
            TarOptions options = new TarOptions().compression(compression).longFileMode(this.tarLongFileMode).bigNumberMode(this.tarBigNumberMode);
            BigInteger size = dataBuilder.buildData(this.dataProducers, tempData, md5s, options);
            this.console.info("Building conffiles");
            List<String> tempConffiles = this.populateConffiles(this.conffilesProducers);
            this.console.debug("Building control");
            ControlBuilder controlBuilder = new ControlBuilder(this.console, this.variableResolver, this.openReplaceToken, this.closeReplaceToken);
            BinaryPackageControlFile packageControlFile = controlBuilder.createPackageControlFile(new File(this.control, "control"), size);
            if (packageControlFile.get("Package") == null) {
                packageControlFile.set("Package", this.packageName);
            }
            if (packageControlFile.get("Section") == null) {
                packageControlFile.set("Section", this.section);
            }
            if (packageControlFile.get("Description") == null) {
                packageControlFile.set("Description", this.description);
            }
            if (packageControlFile.get("Depends") == null && this.depends != null && this.depends.length() > 0) {
                packageControlFile.set("Depends", this.depends);
            }
            if (packageControlFile.get("Homepage") == null) {
                packageControlFile.set("Homepage", this.homepage);
            }
            controlBuilder.buildControl(packageControlFile, this.control.listFiles(), tempConffiles, md5s, tempControl);
            if (!packageControlFile.isValid()) {
                throw new PackagingException("Control file fields are invalid " + packageControlFile.invalidFields() + ". The following fields are mandatory: " + packageControlFile.getMandatoryFields() + ". Please check your pom.xml/build.xml and your control file.");
            }
            this.deb.getParentFile().mkdirs();
            ArArchiveOutputStream ar = new ArArchiveOutputStream(new FileOutputStream(this.deb));
            String binaryName = "debian-binary";
            String binaryContent = "2.0\n";
            String controlName = "control.tar.gz";
            String dataName = "data.tar" + compression.getExtension();
            this.addTo(ar, binaryName, binaryContent);
            this.addTo(ar, controlName, tempControl);
            this.addTo(ar, dataName, tempData);
            if (signatureGenerator != null) {
                this.console.info("Signing package with key " + this.key);
                if (this.signRole == null) {
                    this.signRole = "origin";
                }
                if (this.signMethod == null || !"dpkg-sig".equals(this.signMethod)) {
                    PGPSignatureOutputStream sigStream = new PGPSignatureOutputStream(signatureGenerator);
                    this.addTo(sigStream, binaryContent);
                    this.addTo(sigStream, tempControl);
                    this.addTo(sigStream, tempData);
                    this.addTo(ar, "_gpg" + this.signRole, sigStream.generateASCIISignature());
                } else {
                    String outputStr = "Version: 4\nSigner: \nDate: " + new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.ENGLISH).format(new Date()) + "\nRole: " + this.signRole + "\nFiles: \n" + this.addFile(binaryName, binaryContent) + this.addFile(controlName, tempControl) + this.addFile(dataName, tempData);
                    ByteArrayOutputStream message = new ByteArrayOutputStream();
                    signer.clearSign(outputStr, (OutputStream)message);
                    this.addTo(ar, "_gpg" + this.signRole, message.toString());
                }
            }
            ar.close();
            BinaryPackageControlFile binaryPackageControlFile = packageControlFile;
            return binaryPackageControlFile;
        }
        catch (Exception e) {
            throw new PackagingException("Could not create deb package", e);
        }
        finally {
            if (tempData != null && !tempData.delete()) {
                this.console.warn("Could not delete the temporary file " + tempData);
            }
            if (tempControl != null && !tempControl.delete()) {
                this.console.warn("Could not delete the temporary file " + tempControl);
            }
        }
    }

    private String addFile(String name, String input) {
        return this.addLine(this.md5Hash(input), this.sha1Hash(input), input.length(), name);
    }

    private String addFile(String name, File input) {
        return this.addLine(this.md5Hash(input), this.sha1Hash(input), input.length(), name);
    }

    private String addLine(String md5, String sha1, long size, String name) {
        return "\t" + md5 + " " + sha1 + " " + size + " " + name + "\n";
    }

    private String md5Hash(String input) {
        return this.md5Hash(input.getBytes());
    }

    private String md5Hash(File input) {
        try {
            return this.md5Hash(FileUtils.readFileToByteArray(input));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String md5Hash(byte[] input) {
        MD5Digest md5 = new MD5Digest();
        md5.update(input, 0, input.length);
        byte[] digest = new byte[md5.getDigestSize()];
        md5.doFinal(digest, 0);
        return new String(Hex.encode(digest));
    }

    private String sha1Hash(String input) {
        return this.sha1Hash(input.getBytes());
    }

    private String sha1Hash(File input) {
        try {
            return this.sha1Hash(FileUtils.readFileToByteArray(input));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String sha1Hash(byte[] input) {
        try {
            MessageDigest hash = MessageDigest.getInstance(this.digest);
            hash.update(input);
            byte[] digest = hash.digest();
            return new String(Hex.encode(digest));
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("No such algorithm");
            e.printStackTrace();
            return null;
        }
    }

    private void addTo(ArArchiveOutputStream pOutput, String pName, String pContent) throws IOException {
        byte[] content = pContent.getBytes();
        pOutput.putArchiveEntry(new ArArchiveEntry(pName, content.length));
        pOutput.write(content);
        pOutput.closeArchiveEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTo(ArArchiveOutputStream pOutput, String pName, File pContent) throws IOException {
        pOutput.putArchiveEntry(new ArArchiveEntry(pName, pContent.length()));
        FileInputStream input = new FileInputStream(pContent);
        try {
            Utils.copy(input, pOutput);
        }
        finally {
            ((InputStream)input).close();
        }
        pOutput.closeArchiveEntry();
    }

    private void addTo(PGPSignatureOutputStream pOutput, String pContent) throws IOException {
        byte[] content = pContent.getBytes();
        pOutput.write(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTo(PGPSignatureOutputStream pOutput, File pContent) throws IOException {
        FileInputStream input = new FileInputStream(pContent);
        try {
            Utils.copy(input, pOutput);
        }
        finally {
            ((InputStream)input).close();
        }
    }

    public void setOpenReplaceToken(String openReplaceToken) {
        this.openReplaceToken = openReplaceToken;
    }

    public void setCloseReplaceToken(String closeReplaceToken) {
        this.closeReplaceToken = closeReplaceToken;
    }
}

