/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp.operator.bc;

import java.io.IOException;
import java.util.Date;
import org.vafer.jdeb.shaded.bc.asn1.ASN1ObjectIdentifier;
import org.vafer.jdeb.shaded.bc.asn1.DEROctetString;
import org.vafer.jdeb.shaded.bc.asn1.x509.SubjectPublicKeyInfo;
import org.vafer.jdeb.shaded.bc.asn1.x9.ECNamedCurveTable;
import org.vafer.jdeb.shaded.bc.asn1.x9.X9ECParameters;
import org.vafer.jdeb.shaded.bc.asn1.x9.X9ECPoint;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGObject;
import org.vafer.jdeb.shaded.bc.bcpg.DSAPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.DSASecretBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ECDHPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ECDSAPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ECPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ECSecretBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ElGamalPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ElGamalSecretBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.PublicKeyPacket;
import org.vafer.jdeb.shaded.bc.bcpg.RSAPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.RSASecretBCPGKey;
import org.vafer.jdeb.shaded.bc.crypto.params.AsymmetricKeyParameter;
import org.vafer.jdeb.shaded.bc.crypto.params.DSAParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.DSAPrivateKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.DSAPublicKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.ECDomainParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.ECNamedDomainParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.ECPrivateKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.ECPublicKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.ElGamalParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.ElGamalPrivateKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.ElGamalPublicKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.RSAKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.RSAPrivateCrtKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.util.SubjectPublicKeyInfoFactory;
import org.vafer.jdeb.shaded.bc.openpgp.PGPAlgorithmParameters;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPKdfParameters;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPrivateKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPublicKey;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcUtil;

public class BcPGPKeyConverter {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PGPPublicKey getPGPPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricKeyParameter asymmetricKeyParameter, Date date) throws PGPException {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        void var5_15;
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
            RSAPublicBCPGKey rSAPublicBCPGKey = new RSAPublicBCPGKey(rSAKeyParameters.getModulus(), rSAKeyParameters.getExponent());
            return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        }
        if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)asymmetricKeyParameter;
            DSAParameters dSAParameters = dSAPublicKeyParameters.getParameters();
            DSAPublicBCPGKey dSAPublicBCPGKey = new DSAPublicBCPGKey(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG(), dSAPublicKeyParameters.getY());
            return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        }
        if (asymmetricKeyParameter instanceof ElGamalPublicKeyParameters) {
            ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)asymmetricKeyParameter;
            ElGamalParameters elGamalParameters = elGamalPublicKeyParameters.getParameters();
            ElGamalPublicBCPGKey elGamalPublicBCPGKey = new ElGamalPublicBCPGKey(elGamalParameters.getP(), elGamalParameters.getG(), elGamalPublicKeyParameters.getY());
            return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        }
        if (!(asymmetricKeyParameter instanceof ECPublicKeyParameters)) throw new PGPException("unknown key class");
        try {
            subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymmetricKeyParameter);
        }
        catch (IOException iOException) {
            throw new PGPException("Unable to encode key: " + iOException.getMessage(), iOException);
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
        X9ECParameters x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        DEROctetString dEROctetString = new DEROctetString(subjectPublicKeyInfo.getPublicKeyData().getBytes());
        X9ECPoint x9ECPoint = new X9ECPoint(x9ECParameters.getCurve(), dEROctetString);
        if (n == 18) {
            PGPKdfParameters pGPKdfParameters = (PGPKdfParameters)pGPAlgorithmParameters;
            if (pGPKdfParameters == null) {
                pGPKdfParameters = new PGPKdfParameters(8, 7);
            }
            ECDHPublicBCPGKey eCDHPublicBCPGKey = new ECDHPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint(), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
            return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        } else {
            if (n != 19) throw new PGPException("unknown EC algorithm");
            ECDSAPublicBCPGKey eCDSAPublicBCPGKey = new ECDSAPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint());
        }
        return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
    }

    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pGPPublicKey, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        BCPGObject bCPGObject;
        switch (pGPPublicKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricKeyParameter;
                bCPGObject = new RSASecretBCPGKey(rSAPrivateCrtKeyParameters.getExponent(), rSAPrivateCrtKeyParameters.getP(), rSAPrivateCrtKeyParameters.getQ());
                break;
            }
            case 17: {
                DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)asymmetricKeyParameter;
                bCPGObject = new DSASecretBCPGKey(dSAPrivateKeyParameters.getX());
                break;
            }
            case 16: 
            case 20: {
                ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)asymmetricKeyParameter;
                bCPGObject = new ElGamalSecretBCPGKey(elGamalPrivateKeyParameters.getX());
                break;
            }
            case 18: 
            case 19: {
                ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
                bCPGObject = new ECSecretBCPGKey(eCPrivateKeyParameters.getD());
                break;
            }
            default: {
                throw new PGPException("unknown key class");
            }
        }
        return new PGPPrivateKey(pGPPublicKey.getKeyID(), pGPPublicKey.getPublicKeyPacket(), (BCPGKey)((Object)bCPGObject));
    }

    public AsymmetricKeyParameter getPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new RSAKeyParameters(false, rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new DSAPublicKeyParameters(dSAPublicBCPGKey.getY(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    return new ElGamalPublicKeyParameters(elGamalPublicBCPGKey.getY(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
                case 18: 
                case 19: {
                    ECPublicBCPGKey eCPublicBCPGKey = (ECPublicBCPGKey)publicKeyPacket.getKey();
                    X9ECParameters x9ECParameters = BcUtil.getX9Parameters(eCPublicBCPGKey.getCurveOID());
                    return new ECPublicKeyParameters(BcUtil.decodePoint(eCPublicBCPGKey.getEncodedPoint(), x9ECParameters.getCurve()), (ECDomainParameters)new ECNamedDomainParameters(eCPublicBCPGKey.getCurveOID(), x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH()));
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    public AsymmetricKeyParameter getPrivateKey(PGPPrivateKey pGPPrivateKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        BCPGKey bCPGKey = pGPPrivateKey.getPrivateKeyDataPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)bCPGKey;
                    return new RSAPrivateCrtKeyParameters(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)bCPGKey;
                    return new DSAPrivateKeyParameters(dSASecretBCPGKey.getX(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)bCPGKey;
                    return new ElGamalPrivateKeyParameters(elGamalSecretBCPGKey.getX(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
                case 18: 
                case 19: {
                    ECPublicBCPGKey eCPublicBCPGKey = (ECPublicBCPGKey)publicKeyPacket.getKey();
                    ECSecretBCPGKey eCSecretBCPGKey = (ECSecretBCPGKey)bCPGKey;
                    X9ECParameters x9ECParameters = BcUtil.getX9Parameters(eCPublicBCPGKey.getCurveOID());
                    return new ECPrivateKeyParameters(eCSecretBCPGKey.getX(), (ECDomainParameters)new ECNamedDomainParameters(eCPublicBCPGKey.getCurveOID(), x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH()));
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }
}

