/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.jcajce.provider.asymmetric.edec;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.vafer.jdeb.shaded.bc.crypto.CipherParameters;
import org.vafer.jdeb.shaded.bc.crypto.DerivationFunction;
import org.vafer.jdeb.shaded.bc.crypto.RawAgreement;
import org.vafer.jdeb.shaded.bc.crypto.agreement.X25519Agreement;
import org.vafer.jdeb.shaded.bc.crypto.agreement.X448Agreement;
import org.vafer.jdeb.shaded.bc.crypto.agreement.XDHUnifiedAgreement;
import org.vafer.jdeb.shaded.bc.crypto.params.AsymmetricKeyParameter;
import org.vafer.jdeb.shaded.bc.crypto.params.X25519PrivateKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.X25519PublicKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.X448PrivateKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.X448PublicKeyParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.XDHUPrivateParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.XDHUPublicParameters;
import org.vafer.jdeb.shaded.bc.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import org.vafer.jdeb.shaded.bc.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import org.vafer.jdeb.shaded.bc.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import org.vafer.jdeb.shaded.bc.jcajce.spec.DHUParameterSpec;
import org.vafer.jdeb.shaded.bc.jcajce.spec.UserKeyingMaterialSpec;
import org.vafer.jdeb.shaded.bc.util.Arrays;
import org.vafer.jdeb.shaded.bc.util.BigIntegers;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private RawAgreement agreement;
    private DHUParameterSpec dhuSpec;
    private byte[] result;

    KeyAgreementSpi(String string) {
        super(string, null);
    }

    KeyAgreementSpi(String string, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
    }

    protected byte[] calcSecret() {
        return this.result;
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.getLwXDHKey(key);
        this.agreement = asymmetricKeyParameter instanceof X448PrivateKeyParameters ? this.getAgreement("X448") : this.getAgreement("X25519");
        this.agreement.init((CipherParameters)asymmetricKeyParameter);
        this.ukmParameters = (byte[])(this.kdf != null ? new byte[0] : null);
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.getLwXDHKey(key);
        this.agreement = asymmetricKeyParameter instanceof X448PrivateKeyParameters ? this.getAgreement("X448") : this.getAgreement("X25519");
        this.ukmParameters = null;
        if (algorithmParameterSpec instanceof DHUParameterSpec) {
            if (this.kaAlgorithm.indexOf(85) < 0) {
                throw new InvalidAlgorithmParameterException("agreement algorithm not DHU based");
            }
            this.dhuSpec = (DHUParameterSpec)algorithmParameterSpec;
            this.ukmParameters = this.dhuSpec.getUserKeyingMaterial();
            this.agreement.init((CipherParameters)new XDHUPrivateParameters(asymmetricKeyParameter, ((BCXDHPrivateKey)this.dhuSpec.getEphemeralPrivateKey()).engineGetKeyParameters(), ((BCXDHPublicKey)this.dhuSpec.getEphemeralPublicKey()).engineGetKeyParameters()));
        } else {
            this.agreement.init((CipherParameters)asymmetricKeyParameter);
            if (algorithmParameterSpec instanceof UserKeyingMaterialSpec) {
                if (this.kdf == null) {
                    throw new InvalidAlgorithmParameterException("no KDF specified for UserKeyingMaterialSpec");
                }
                this.ukmParameters = ((UserKeyingMaterialSpec)algorithmParameterSpec).getUserKeyingMaterial();
            } else {
                throw new InvalidAlgorithmParameterException("unknown ParameterSpec");
            }
        }
        if (this.kdf != null && this.ukmParameters == null) {
            this.ukmParameters = new byte[0];
        }
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (this.agreement == null) {
            throw new IllegalStateException(this.kaAlgorithm + " not initialised.");
        }
        if (!bl) {
            throw new IllegalStateException(this.kaAlgorithm + " can only be between two parties.");
        }
        if (key instanceof BCXDHPublicKey) {
            asymmetricKeyParameter = ((BCXDHPublicKey)key).engineGetKeyParameters();
        } else if (key instanceof XECPublicKey) {
            XECPublicKey xECPublicKey = (XECPublicKey)key;
            byte[] byArray = Arrays.reverse(BigIntegers.asUnsignedByteArray(xECPublicKey.getU()));
            asymmetricKeyParameter = byArray.length == 56 ? new X448PublicKeyParameters(byArray, 0) : new X25519PublicKeyParameters(byArray, 0);
        } else {
            throw new InvalidKeyException("cannot identify XDH private key");
        }
        this.result = new byte[this.agreement.getAgreementSize()];
        if (this.dhuSpec != null) {
            this.agreement.calculateAgreement((CipherParameters)new XDHUPublicParameters(asymmetricKeyParameter, ((BCXDHPublicKey)this.dhuSpec.getOtherPartyEphemeralKey()).engineGetKeyParameters()), this.result, 0);
        } else {
            this.agreement.calculateAgreement((CipherParameters)asymmetricKeyParameter, this.result, 0);
        }
        return null;
    }

    private RawAgreement getAgreement(String string) throws InvalidKeyException {
        if (!this.kaAlgorithm.equals("XDH") && !this.kaAlgorithm.startsWith(string)) {
            throw new InvalidKeyException("inappropriate key for " + this.kaAlgorithm);
        }
        if (this.kaAlgorithm.indexOf(85) > 0) {
            if (string.startsWith("X448")) {
                return new XDHUnifiedAgreement((RawAgreement)new X448Agreement());
            }
            return new XDHUnifiedAgreement((RawAgreement)new X25519Agreement());
        }
        if (string.startsWith("X448")) {
            return new X448Agreement();
        }
        return new X25519Agreement();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AsymmetricKeyParameter getLwXDHKey(Key key) throws InvalidKeyException {
        if (key instanceof BCXDHPrivateKey) {
            return ((BCXDHPrivateKey)key).engineGetKeyParameters();
        }
        if (!(key instanceof XECPrivateKey)) throw new InvalidKeyException("cannot identify XDH private key");
        XECPrivateKey xECPrivateKey = (XECPrivateKey)key;
        if (!xECPrivateKey.getScalar().isPresent()) throw new InvalidKeyException("cannot use other provider XEC private key");
        byte[] byArray = xECPrivateKey.getScalar().get();
        if (byArray.length != 56) return new X25519PrivateKeyParameters(byArray, 0);
        return new X448PrivateKeyParameters(byArray, 0);
    }
}

