/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp.operator.bc;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.vafer.jdeb.shaded.bc.asn1.ASN1ObjectIdentifier;
import org.vafer.jdeb.shaded.bc.asn1.x9.ECNamedCurveTable;
import org.vafer.jdeb.shaded.bc.asn1.x9.X9ECParameters;
import org.vafer.jdeb.shaded.bc.crypto.BlockCipher;
import org.vafer.jdeb.shaded.bc.crypto.BufferedBlockCipher;
import org.vafer.jdeb.shaded.bc.crypto.ec.CustomNamedCurves;
import org.vafer.jdeb.shaded.bc.crypto.io.CipherInputStream;
import org.vafer.jdeb.shaded.bc.crypto.modes.CFBBlockCipher;
import org.vafer.jdeb.shaded.bc.crypto.modes.OpenPGPCFBBlockCipher;
import org.vafer.jdeb.shaded.bc.crypto.params.KeyParameter;
import org.vafer.jdeb.shaded.bc.crypto.params.ParametersWithIV;
import org.vafer.jdeb.shaded.bc.math.ec.ECCurve;
import org.vafer.jdeb.shaded.bc.math.ec.ECPoint;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPDataDecryptor;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPDigestCalculator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.vafer.jdeb.shaded.bc.util.BigIntegers;

class BcUtil {
    BcUtil() {
    }

    static BufferedBlockCipher createStreamCipher(boolean bl, BlockCipher blockCipher, boolean bl2, byte[] byArray) {
        BufferedBlockCipher bufferedBlockCipher = bl2 ? new BufferedBlockCipher(new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8)) : new BufferedBlockCipher(new OpenPGPCFBBlockCipher(blockCipher));
        KeyParameter keyParameter = new KeyParameter(byArray);
        if (bl2) {
            bufferedBlockCipher.init(bl, new ParametersWithIV(keyParameter, new byte[blockCipher.getBlockSize()]));
        } else {
            bufferedBlockCipher.init(bl, keyParameter);
        }
        return bufferedBlockCipher;
    }

    public static PGPDataDecryptor createDataDecryptor(boolean bl, BlockCipher blockCipher, byte[] byArray) {
        final BufferedBlockCipher bufferedBlockCipher = BcUtil.createStreamCipher(false, blockCipher, bl, byArray);
        return new PGPDataDecryptor(){

            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, bufferedBlockCipher);
            }

            public int getBlockSize() {
                return bufferedBlockCipher.getBlockSize();
            }

            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    public static BufferedBlockCipher createSymmetricKeyWrapper(boolean bl, BlockCipher blockCipher, byte[] byArray, byte[] byArray2) {
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher(new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8));
        bufferedBlockCipher.init(bl, new ParametersWithIV(new KeyParameter(byArray), byArray2));
        return bufferedBlockCipher;
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    static ECPoint decodePoint(BigInteger bigInteger, ECCurve eCCurve) throws IOException {
        return eCCurve.decodePoint(BigIntegers.asUnsignedByteArray(bigInteger));
    }
}

