/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdependency;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.vafer.jdependency.Clazz;

public final class ClazzpathUnit {
    private final String id;
    private final Map<String, Clazz> clazzes;
    private final Map<String, Clazz> dependencies;

    ClazzpathUnit(String pId, Map<String, Clazz> pClazzes, Map<String, Clazz> pDependencies) {
        this.id = pId;
        this.clazzes = pClazzes;
        this.dependencies = pDependencies;
    }

    public Set<Clazz> getClazzes() {
        return new HashSet<Clazz>(this.clazzes.values());
    }

    public Map<String, Clazz> getClazzesMap() {
        return new TreeMap<String, Clazz>(this.clazzes);
    }

    public Clazz getClazz(String pClazzName) {
        return this.clazzes.get(pClazzName);
    }

    public Set<Clazz> getDependencies() {
        return new HashSet<Clazz>(this.dependencies.values());
    }

    public Set<Clazz> getTransitiveDependencies() {
        HashSet<Clazz> all = new HashSet<Clazz>();
        for (Clazz clazz : this.clazzes.values()) {
            clazz.findTransitiveDependencies(all);
        }
        return all;
    }

    public String toString() {
        return this.id;
    }
}

